/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType;
import software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MacAlgorithmDukpt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MacAlgorithmDukpt> {
    private static final SdkField<String> DUKPT_DERIVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptDerivationType").getter(MacAlgorithmDukpt.getter(MacAlgorithmDukpt::dukptDerivationTypeAsString)).setter(MacAlgorithmDukpt.setter(Builder::dukptDerivationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptDerivationType").build()}).build();
    private static final SdkField<String> DUKPT_KEY_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DukptKeyVariant").getter(MacAlgorithmDukpt.getter(MacAlgorithmDukpt::dukptKeyVariantAsString)).setter(MacAlgorithmDukpt.setter(Builder::dukptKeyVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptKeyVariant").build()}).build();
    private static final SdkField<String> KEY_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeySerialNumber").getter(MacAlgorithmDukpt.getter(MacAlgorithmDukpt::keySerialNumber)).setter(MacAlgorithmDukpt.setter(Builder::keySerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySerialNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DUKPT_DERIVATION_TYPE_FIELD, DUKPT_KEY_VARIANT_FIELD, KEY_SERIAL_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dukptDerivationType;
    private final String dukptKeyVariant;
    private final String keySerialNumber;

    private MacAlgorithmDukpt(BuilderImpl builder) {
        this.dukptDerivationType = builder.dukptDerivationType;
        this.dukptKeyVariant = builder.dukptKeyVariant;
        this.keySerialNumber = builder.keySerialNumber;
    }

    public final DukptDerivationType dukptDerivationType() {
        return DukptDerivationType.fromValue(this.dukptDerivationType);
    }

    public final String dukptDerivationTypeAsString() {
        return this.dukptDerivationType;
    }

    public final DukptKeyVariant dukptKeyVariant() {
        return DukptKeyVariant.fromValue(this.dukptKeyVariant);
    }

    public final String dukptKeyVariantAsString() {
        return this.dukptKeyVariant;
    }

    public final String keySerialNumber() {
        return this.keySerialNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptDerivationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dukptKeyVariantAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySerialNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MacAlgorithmDukpt)) {
            return false;
        }
        MacAlgorithmDukpt other = (MacAlgorithmDukpt)obj;
        return Objects.equals(this.dukptDerivationTypeAsString(), other.dukptDerivationTypeAsString()) && Objects.equals(this.dukptKeyVariantAsString(), other.dukptKeyVariantAsString()) && Objects.equals(this.keySerialNumber(), other.keySerialNumber());
    }

    public final String toString() {
        return ToString.builder((String)"MacAlgorithmDukpt").add("DukptDerivationType", (Object)this.dukptDerivationTypeAsString()).add("DukptKeyVariant", (Object)this.dukptKeyVariantAsString()).add("KeySerialNumber", (Object)this.keySerialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DukptDerivationType": {
                return Optional.ofNullable(clazz.cast(this.dukptDerivationTypeAsString()));
            }
            case "DukptKeyVariant": {
                return Optional.ofNullable(clazz.cast(this.dukptKeyVariantAsString()));
            }
            case "KeySerialNumber": {
                return Optional.ofNullable(clazz.cast(this.keySerialNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MacAlgorithmDukpt, T> g) {
        return obj -> g.apply((MacAlgorithmDukpt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dukptDerivationType;
        private String dukptKeyVariant;
        private String keySerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(MacAlgorithmDukpt model) {
            this.dukptDerivationType(model.dukptDerivationType);
            this.dukptKeyVariant(model.dukptKeyVariant);
            this.keySerialNumber(model.keySerialNumber);
        }

        public final String getDukptDerivationType() {
            return this.dukptDerivationType;
        }

        public final void setDukptDerivationType(String dukptDerivationType) {
            this.dukptDerivationType = dukptDerivationType;
        }

        @Override
        public final Builder dukptDerivationType(String dukptDerivationType) {
            this.dukptDerivationType = dukptDerivationType;
            return this;
        }

        @Override
        public final Builder dukptDerivationType(DukptDerivationType dukptDerivationType) {
            this.dukptDerivationType(dukptDerivationType == null ? null : dukptDerivationType.toString());
            return this;
        }

        public final String getDukptKeyVariant() {
            return this.dukptKeyVariant;
        }

        public final void setDukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
        }

        @Override
        public final Builder dukptKeyVariant(String dukptKeyVariant) {
            this.dukptKeyVariant = dukptKeyVariant;
            return this;
        }

        @Override
        public final Builder dukptKeyVariant(DukptKeyVariant dukptKeyVariant) {
            this.dukptKeyVariant(dukptKeyVariant == null ? null : dukptKeyVariant.toString());
            return this;
        }

        public final String getKeySerialNumber() {
            return this.keySerialNumber;
        }

        public final void setKeySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
        }

        @Override
        public final Builder keySerialNumber(String keySerialNumber) {
            this.keySerialNumber = keySerialNumber;
            return this;
        }

        public MacAlgorithmDukpt build() {
            return new MacAlgorithmDukpt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MacAlgorithmDukpt> {
        public Builder dukptDerivationType(String var1);

        public Builder dukptDerivationType(DukptDerivationType var1);

        public Builder dukptKeyVariant(String var1);

        public Builder dukptKeyVariant(DukptKeyVariant var1);

        public Builder keySerialNumber(String var1);
    }
}

