/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyPinDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<VerifyPinDataRequest.Builder, VerifyPinDataRequest> {
    private static final SdkField<DukptAttributes> DUKPT_ATTRIBUTES_FIELD = SdkField
            .<DukptAttributes> builder(MarshallingType.SDK_POJO).memberName("DukptAttributes")
            .getter(getter(VerifyPinDataRequest::dukptAttributes)).setter(setter(Builder::dukptAttributes))
            .constructor(DukptAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DukptAttributes").build()).build();

    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedPinBlock").getter(getter(VerifyPinDataRequest::encryptedPinBlock))
            .setter(setter(Builder::encryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyIdentifier").getter(getter(VerifyPinDataRequest::encryptionKeyIdentifier))
            .setter(setter(Builder::encryptionKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyIdentifier").build())
            .build();

    private static final SdkField<String> PIN_BLOCK_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlockFormat").getter(getter(VerifyPinDataRequest::pinBlockFormatAsString))
            .setter(setter(Builder::pinBlockFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockFormat").build()).build();

    private static final SdkField<Integer> PIN_DATA_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PinDataLength").getter(getter(VerifyPinDataRequest::pinDataLength))
            .setter(setter(Builder::pinDataLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinDataLength").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(VerifyPinDataRequest::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<PinVerificationAttributes> VERIFICATION_ATTRIBUTES_FIELD = SdkField
            .<PinVerificationAttributes> builder(MarshallingType.SDK_POJO).memberName("VerificationAttributes")
            .getter(getter(VerifyPinDataRequest::verificationAttributes)).setter(setter(Builder::verificationAttributes))
            .constructor(PinVerificationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build())
            .build();

    private static final SdkField<String> VERIFICATION_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationKeyIdentifier").getter(getter(VerifyPinDataRequest::verificationKeyIdentifier))
            .setter(setter(Builder::verificationKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationKeyIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DUKPT_ATTRIBUTES_FIELD,
            ENCRYPTED_PIN_BLOCK_FIELD, ENCRYPTION_KEY_IDENTIFIER_FIELD, PIN_BLOCK_FORMAT_FIELD, PIN_DATA_LENGTH_FIELD,
            PRIMARY_ACCOUNT_NUMBER_FIELD, VERIFICATION_ATTRIBUTES_FIELD, VERIFICATION_KEY_IDENTIFIER_FIELD));

    private final DukptAttributes dukptAttributes;

    private final String encryptedPinBlock;

    private final String encryptionKeyIdentifier;

    private final String pinBlockFormat;

    private final Integer pinDataLength;

    private final String primaryAccountNumber;

    private final PinVerificationAttributes verificationAttributes;

    private final String verificationKeyIdentifier;

    private VerifyPinDataRequest(BuilderImpl builder) {
        super(builder);
        this.dukptAttributes = builder.dukptAttributes;
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.encryptionKeyIdentifier = builder.encryptionKeyIdentifier;
        this.pinBlockFormat = builder.pinBlockFormat;
        this.pinDataLength = builder.pinDataLength;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.verificationAttributes = builder.verificationAttributes;
        this.verificationKeyIdentifier = builder.verificationKeyIdentifier;
    }

    /**
     * <p>
     * The attributes and values for the DUKPT encrypted PIN block data.
     * </p>
     * 
     * @return The attributes and values for the DUKPT encrypted PIN block data.
     */
    public final DukptAttributes dukptAttributes() {
        return dukptAttributes;
    }

    /**
     * <p>
     * The encrypted PIN block data that Amazon Web Services Payment Cryptography verifies.
     * </p>
     * 
     * @return The encrypted PIN block data that Amazon Web Services Payment Cryptography verifies.
     */
    public final String encryptedPinBlock() {
        return encryptedPinBlock;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key under which the PIN block data is encrypted. This key type can be
     * PEK or BDK.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key under which the PIN block data is encrypted. This key type
     *         can be PEK or BDK.
     */
    public final String encryptionKeyIdentifier() {
        return encryptionKeyIdentifier;
    }

    /**
     * <p>
     * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
     * </p>
     * <p>
     * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
     * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
     * </p>
     * <p>
     * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
     * digits are random values from 10 to 15.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pinBlockFormat}
     * will return {@link PinBlockFormatForPinData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pinBlockFormatAsString}.
     * </p>
     * 
     * @return The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     *         Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
     *         <p>
     *         The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
     *         block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
     *         length.
     *         </p>
     *         <p>
     *         The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the
     *         fill digits are random values from 10 to 15.
     * @see PinBlockFormatForPinData
     */
    public final PinBlockFormatForPinData pinBlockFormat() {
        return PinBlockFormatForPinData.fromValue(pinBlockFormat);
    }

    /**
     * <p>
     * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
     * </p>
     * <p>
     * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
     * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
     * </p>
     * <p>
     * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
     * digits are random values from 10 to 15.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pinBlockFormat}
     * will return {@link PinBlockFormatForPinData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #pinBlockFormatAsString}.
     * </p>
     * 
     * @return The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
     *         Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
     *         <p>
     *         The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
     *         block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
     *         length.
     *         </p>
     *         <p>
     *         The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the
     *         fill digits are random values from 10 to 15.
     * @see PinBlockFormatForPinData
     */
    public final String pinBlockFormatAsString() {
        return pinBlockFormat;
    }

    /**
     * <p>
     * The length of PIN being verified.
     * </p>
     * 
     * @return The length of PIN being verified.
     */
    public final Integer pinDataLength() {
        return pinDataLength;
    }

    /**
     * <p>
     * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the card
     * with a specific account holder.
     * </p>
     * 
     * @return The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates
     *         the card with a specific account holder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * The attributes and values for PIN data verification.
     * </p>
     * 
     * @return The attributes and values for PIN data verification.
     */
    public final PinVerificationAttributes verificationAttributes() {
        return verificationAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PIN verification key.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PIN verification key.
     */
    public final String verificationKeyIdentifier() {
        return verificationKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dukptAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(pinBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pinDataLength());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(verificationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(verificationKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyPinDataRequest)) {
            return false;
        }
        VerifyPinDataRequest other = (VerifyPinDataRequest) obj;
        return Objects.equals(dukptAttributes(), other.dukptAttributes())
                && Objects.equals(encryptedPinBlock(), other.encryptedPinBlock())
                && Objects.equals(encryptionKeyIdentifier(), other.encryptionKeyIdentifier())
                && Objects.equals(pinBlockFormatAsString(), other.pinBlockFormatAsString())
                && Objects.equals(pinDataLength(), other.pinDataLength())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(verificationAttributes(), other.verificationAttributes())
                && Objects.equals(verificationKeyIdentifier(), other.verificationKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyPinDataRequest").add("DukptAttributes", dukptAttributes())
                .add("EncryptedPinBlock", encryptedPinBlock()).add("EncryptionKeyIdentifier", encryptionKeyIdentifier())
                .add("PinBlockFormat", pinBlockFormatAsString()).add("PinDataLength", pinDataLength())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VerificationAttributes", verificationAttributes())
                .add("VerificationKeyIdentifier", verificationKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DukptAttributes":
            return Optional.ofNullable(clazz.cast(dukptAttributes()));
        case "EncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(encryptedPinBlock()));
        case "EncryptionKeyIdentifier":
            return Optional.ofNullable(clazz.cast(encryptionKeyIdentifier()));
        case "PinBlockFormat":
            return Optional.ofNullable(clazz.cast(pinBlockFormatAsString()));
        case "PinDataLength":
            return Optional.ofNullable(clazz.cast(pinDataLength()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "VerificationAttributes":
            return Optional.ofNullable(clazz.cast(verificationAttributes()));
        case "VerificationKeyIdentifier":
            return Optional.ofNullable(clazz.cast(verificationKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyPinDataRequest, T> g) {
        return obj -> g.apply((VerifyPinDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, VerifyPinDataRequest> {
        /**
         * <p>
         * The attributes and values for the DUKPT encrypted PIN block data.
         * </p>
         * 
         * @param dukptAttributes
         *        The attributes and values for the DUKPT encrypted PIN block data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dukptAttributes(DukptAttributes dukptAttributes);

        /**
         * <p>
         * The attributes and values for the DUKPT encrypted PIN block data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DukptAttributes.Builder} avoiding the
         * need to create one manually via {@link DukptAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DukptAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #dukptAttributes(DukptAttributes)}.
         * 
         * @param dukptAttributes
         *        a consumer that will call methods on {@link DukptAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dukptAttributes(DukptAttributes)
         */
        default Builder dukptAttributes(Consumer<DukptAttributes.Builder> dukptAttributes) {
            return dukptAttributes(DukptAttributes.builder().applyMutation(dukptAttributes).build());
        }

        /**
         * <p>
         * The encrypted PIN block data that Amazon Web Services Payment Cryptography verifies.
         * </p>
         * 
         * @param encryptedPinBlock
         *        The encrypted PIN block data that Amazon Web Services Payment Cryptography verifies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedPinBlock(String encryptedPinBlock);

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key under which the PIN block data is encrypted. This key type can
         * be PEK or BDK.
         * </p>
         * 
         * @param encryptionKeyIdentifier
         *        The <code>keyARN</code> of the encryption key under which the PIN block data is encrypted. This key
         *        type can be PEK or BDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyIdentifier(String encryptionKeyIdentifier);

        /**
         * <p>
         * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
         * </p>
         * <p>
         * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
         * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
         * </p>
         * <p>
         * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
         * digits are random values from 10 to 15.
         * </p>
         * 
         * @param pinBlockFormat
         *        The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         *        Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
         *        <p>
         *        The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
         *        block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
         *        length.
         *        </p>
         *        <p>
         *        The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that
         *        the fill digits are random values from 10 to 15.
         * @see PinBlockFormatForPinData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockFormatForPinData
         */
        Builder pinBlockFormat(String pinBlockFormat);

        /**
         * <p>
         * The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         * Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.
         * </p>
         * <p>
         * The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN block
         * formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in length.
         * </p>
         * <p>
         * The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that the fill
         * digits are random values from 10 to 15.
         * </p>
         * 
         * @param pinBlockFormat
         *        The PIN encoding format for pin data generation as specified in ISO 9564. Amazon Web Services Payment
         *        Cryptography supports <code>ISO_Format_0</code> and <code>ISO_Format_3</code>.</p>
         *        <p>
         *        The <code>ISO_Format_0</code> PIN block format is equivalent to the ANSI X9.8, VISA-1, and ECI-1 PIN
         *        block formats. It is similar to a VISA-4 PIN block format. It supports a PIN from 4 to 12 digits in
         *        length.
         *        </p>
         *        <p>
         *        The <code>ISO_Format_3</code> PIN block format is the same as <code>ISO_Format_0</code> except that
         *        the fill digits are random values from 10 to 15.
         * @see PinBlockFormatForPinData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockFormatForPinData
         */
        Builder pinBlockFormat(PinBlockFormatForPinData pinBlockFormat);

        /**
         * <p>
         * The length of PIN being verified.
         * </p>
         * 
         * @param pinDataLength
         *        The length of PIN being verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinDataLength(Integer pinDataLength);

        /**
         * <p>
         * The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that associates the
         * card with a specific account holder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN), a unique identifier for a payment credit or debit card that
         *        associates the card with a specific account holder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * The attributes and values for PIN data verification.
         * </p>
         * 
         * @param verificationAttributes
         *        The attributes and values for PIN data verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationAttributes(PinVerificationAttributes verificationAttributes);

        /**
         * <p>
         * The attributes and values for PIN data verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link PinVerificationAttributes.Builder}
         * avoiding the need to create one manually via {@link PinVerificationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PinVerificationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #verificationAttributes(PinVerificationAttributes)}.
         * 
         * @param verificationAttributes
         *        a consumer that will call methods on {@link PinVerificationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationAttributes(PinVerificationAttributes)
         */
        default Builder verificationAttributes(Consumer<PinVerificationAttributes.Builder> verificationAttributes) {
            return verificationAttributes(PinVerificationAttributes.builder().applyMutation(verificationAttributes).build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the PIN verification key.
         * </p>
         * 
         * @param verificationKeyIdentifier
         *        The <code>keyARN</code> of the PIN verification key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationKeyIdentifier(String verificationKeyIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private DukptAttributes dukptAttributes;

        private String encryptedPinBlock;

        private String encryptionKeyIdentifier;

        private String pinBlockFormat;

        private Integer pinDataLength;

        private String primaryAccountNumber;

        private PinVerificationAttributes verificationAttributes;

        private String verificationKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyPinDataRequest model) {
            super(model);
            dukptAttributes(model.dukptAttributes);
            encryptedPinBlock(model.encryptedPinBlock);
            encryptionKeyIdentifier(model.encryptionKeyIdentifier);
            pinBlockFormat(model.pinBlockFormat);
            pinDataLength(model.pinDataLength);
            primaryAccountNumber(model.primaryAccountNumber);
            verificationAttributes(model.verificationAttributes);
            verificationKeyIdentifier(model.verificationKeyIdentifier);
        }

        public final DukptAttributes.Builder getDukptAttributes() {
            return dukptAttributes != null ? dukptAttributes.toBuilder() : null;
        }

        public final void setDukptAttributes(DukptAttributes.BuilderImpl dukptAttributes) {
            this.dukptAttributes = dukptAttributes != null ? dukptAttributes.build() : null;
        }

        @Override
        public final Builder dukptAttributes(DukptAttributes dukptAttributes) {
            this.dukptAttributes = dukptAttributes;
            return this;
        }

        public final String getEncryptedPinBlock() {
            return encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getEncryptionKeyIdentifier() {
            return encryptionKeyIdentifier;
        }

        public final void setEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
        }

        @Override
        public final Builder encryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
            return this;
        }

        public final String getPinBlockFormat() {
            return pinBlockFormat;
        }

        public final void setPinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
        }

        @Override
        public final Builder pinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
            return this;
        }

        @Override
        public final Builder pinBlockFormat(PinBlockFormatForPinData pinBlockFormat) {
            this.pinBlockFormat(pinBlockFormat == null ? null : pinBlockFormat.toString());
            return this;
        }

        public final Integer getPinDataLength() {
            return pinDataLength;
        }

        public final void setPinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
        }

        @Override
        public final Builder pinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final PinVerificationAttributes.Builder getVerificationAttributes() {
            return verificationAttributes != null ? verificationAttributes.toBuilder() : null;
        }

        public final void setVerificationAttributes(PinVerificationAttributes.BuilderImpl verificationAttributes) {
            this.verificationAttributes = verificationAttributes != null ? verificationAttributes.build() : null;
        }

        @Override
        public final Builder verificationAttributes(PinVerificationAttributes verificationAttributes) {
            this.verificationAttributes = verificationAttributes;
            return this;
        }

        public final String getVerificationKeyIdentifier() {
            return verificationKeyIdentifier;
        }

        public final void setVerificationKeyIdentifier(String verificationKeyIdentifier) {
            this.verificationKeyIdentifier = verificationKeyIdentifier;
        }

        @Override
        public final Builder verificationKeyIdentifier(String verificationKeyIdentifier) {
            this.verificationKeyIdentifier = verificationKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyPinDataRequest build() {
            return new VerifyPinDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
