/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information for key material export from Amazon Web Services Payment Cryptography using TR-31 or TR-34 or
 * RSA wrap and unwrap key exchange method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportKeyMaterial implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportKeyMaterial.Builder, ExportKeyMaterial> {
    private static final SdkField<ExportTr31KeyBlock> TR31_KEY_BLOCK_FIELD = SdkField
            .<ExportTr31KeyBlock> builder(MarshallingType.SDK_POJO).memberName("Tr31KeyBlock")
            .getter(getter(ExportKeyMaterial::tr31KeyBlock)).setter(setter(Builder::tr31KeyBlock))
            .constructor(ExportTr31KeyBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr31KeyBlock").build()).build();

    private static final SdkField<ExportTr34KeyBlock> TR34_KEY_BLOCK_FIELD = SdkField
            .<ExportTr34KeyBlock> builder(MarshallingType.SDK_POJO).memberName("Tr34KeyBlock")
            .getter(getter(ExportKeyMaterial::tr34KeyBlock)).setter(setter(Builder::tr34KeyBlock))
            .constructor(ExportTr34KeyBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr34KeyBlock").build()).build();

    private static final SdkField<ExportKeyCryptogram> KEY_CRYPTOGRAM_FIELD = SdkField
            .<ExportKeyCryptogram> builder(MarshallingType.SDK_POJO).memberName("KeyCryptogram")
            .getter(getter(ExportKeyMaterial::keyCryptogram)).setter(setter(Builder::keyCryptogram))
            .constructor(ExportKeyCryptogram::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCryptogram").build()).build();

    private static final SdkField<ExportDiffieHellmanTr31KeyBlock> DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD = SdkField
            .<ExportDiffieHellmanTr31KeyBlock> builder(MarshallingType.SDK_POJO).memberName("DiffieHellmanTr31KeyBlock")
            .getter(getter(ExportKeyMaterial::diffieHellmanTr31KeyBlock)).setter(setter(Builder::diffieHellmanTr31KeyBlock))
            .constructor(ExportDiffieHellmanTr31KeyBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiffieHellmanTr31KeyBlock").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TR31_KEY_BLOCK_FIELD,
            TR34_KEY_BLOCK_FIELD, KEY_CRYPTOGRAM_FIELD, DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExportTr31KeyBlock tr31KeyBlock;

    private final ExportTr34KeyBlock tr34KeyBlock;

    private final ExportKeyCryptogram keyCryptogram;

    private final ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock;

    private final Type type;

    private ExportKeyMaterial(BuilderImpl builder) {
        this.tr31KeyBlock = builder.tr31KeyBlock;
        this.tr34KeyBlock = builder.tr34KeyBlock;
        this.keyCryptogram = builder.keyCryptogram;
        this.diffieHellmanTr31KeyBlock = builder.diffieHellmanTr31KeyBlock;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameter information for key material export using symmetric TR-31 key exchange method.
     * </p>
     * 
     * @return Parameter information for key material export using symmetric TR-31 key exchange method.
     */
    public final ExportTr31KeyBlock tr31KeyBlock() {
        return tr31KeyBlock;
    }

    /**
     * <p>
     * Parameter information for key material export using the asymmetric TR-34 key exchange method.
     * </p>
     * 
     * @return Parameter information for key material export using the asymmetric TR-34 key exchange method.
     */
    public final ExportTr34KeyBlock tr34KeyBlock() {
        return tr34KeyBlock;
    }

    /**
     * <p>
     * Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
     * </p>
     * 
     * @return Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
     */
    public final ExportKeyCryptogram keyCryptogram() {
        return keyCryptogram;
    }

    /**
     * <p>
     * Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
     * </p>
     * 
     * @return Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
     */
    public final ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock() {
        return diffieHellmanTr31KeyBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tr31KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(tr34KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(keyCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(diffieHellmanTr31KeyBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyMaterial)) {
            return false;
        }
        ExportKeyMaterial other = (ExportKeyMaterial) obj;
        return Objects.equals(tr31KeyBlock(), other.tr31KeyBlock()) && Objects.equals(tr34KeyBlock(), other.tr34KeyBlock())
                && Objects.equals(keyCryptogram(), other.keyCryptogram())
                && Objects.equals(diffieHellmanTr31KeyBlock(), other.diffieHellmanTr31KeyBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportKeyMaterial").add("Tr31KeyBlock", tr31KeyBlock()).add("Tr34KeyBlock", tr34KeyBlock())
                .add("KeyCryptogram", keyCryptogram()).add("DiffieHellmanTr31KeyBlock", diffieHellmanTr31KeyBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tr31KeyBlock":
            return Optional.ofNullable(clazz.cast(tr31KeyBlock()));
        case "Tr34KeyBlock":
            return Optional.ofNullable(clazz.cast(tr34KeyBlock()));
        case "KeyCryptogram":
            return Optional.ofNullable(clazz.cast(keyCryptogram()));
        case "DiffieHellmanTr31KeyBlock":
            return Optional.ofNullable(clazz.cast(diffieHellmanTr31KeyBlock()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material export using symmetric TR-31 key exchange method.
     * </p>
     * 
     * @param tr31KeyBlock
     *        Parameter information for key material export using symmetric TR-31 key exchange method.
     */
    public static ExportKeyMaterial fromTr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock) {
        return builder().tr31KeyBlock(tr31KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #tr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material export using symmetric TR-31 key exchange method.
     * </p>
     * 
     * @param tr31KeyBlock
     *        Parameter information for key material export using symmetric TR-31 key exchange method.
     */
    public static ExportKeyMaterial fromTr31KeyBlock(Consumer<ExportTr31KeyBlock.Builder> tr31KeyBlock) {
        ExportTr31KeyBlock.Builder builder = ExportTr31KeyBlock.builder();
        tr31KeyBlock.accept(builder);
        return fromTr31KeyBlock(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tr34KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material export using the asymmetric TR-34 key exchange method.
     * </p>
     * 
     * @param tr34KeyBlock
     *        Parameter information for key material export using the asymmetric TR-34 key exchange method.
     */
    public static ExportKeyMaterial fromTr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock) {
        return builder().tr34KeyBlock(tr34KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #tr34KeyBlock()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material export using the asymmetric TR-34 key exchange method.
     * </p>
     * 
     * @param tr34KeyBlock
     *        Parameter information for key material export using the asymmetric TR-34 key exchange method.
     */
    public static ExportKeyMaterial fromTr34KeyBlock(Consumer<ExportTr34KeyBlock.Builder> tr34KeyBlock) {
        ExportTr34KeyBlock.Builder builder = ExportTr34KeyBlock.builder();
        tr34KeyBlock.accept(builder);
        return fromTr34KeyBlock(builder.build());
    }

    /**
     * Create an instance of this class with {@link #keyCryptogram()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
     * </p>
     * 
     * @param keyCryptogram
     *        Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
     */
    public static ExportKeyMaterial fromKeyCryptogram(ExportKeyCryptogram keyCryptogram) {
        return builder().keyCryptogram(keyCryptogram).build();
    }

    /**
     * Create an instance of this class with {@link #keyCryptogram()} initialized to the given value.
     *
     * <p>
     * Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
     * </p>
     * 
     * @param keyCryptogram
     *        Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
     */
    public static ExportKeyMaterial fromKeyCryptogram(Consumer<ExportKeyCryptogram.Builder> keyCryptogram) {
        ExportKeyCryptogram.Builder builder = ExportKeyCryptogram.builder();
        keyCryptogram.accept(builder);
        return fromKeyCryptogram(builder.build());
    }

    /**
     * Create an instance of this class with {@link #diffieHellmanTr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
     * </p>
     * 
     * @param diffieHellmanTr31KeyBlock
     *        Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
     */
    public static ExportKeyMaterial fromDiffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock) {
        return builder().diffieHellmanTr31KeyBlock(diffieHellmanTr31KeyBlock).build();
    }

    /**
     * Create an instance of this class with {@link #diffieHellmanTr31KeyBlock()} initialized to the given value.
     *
     * <p>
     * Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
     * </p>
     * 
     * @param diffieHellmanTr31KeyBlock
     *        Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
     */
    public static ExportKeyMaterial fromDiffieHellmanTr31KeyBlock(
            Consumer<ExportDiffieHellmanTr31KeyBlock.Builder> diffieHellmanTr31KeyBlock) {
        ExportDiffieHellmanTr31KeyBlock.Builder builder = ExportDiffieHellmanTr31KeyBlock.builder();
        diffieHellmanTr31KeyBlock.accept(builder);
        return fromDiffieHellmanTr31KeyBlock(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tr31KeyBlock", TR31_KEY_BLOCK_FIELD);
        map.put("Tr34KeyBlock", TR34_KEY_BLOCK_FIELD);
        map.put("KeyCryptogram", KEY_CRYPTOGRAM_FIELD);
        map.put("DiffieHellmanTr31KeyBlock", DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportKeyMaterial, T> g) {
        return obj -> g.apply((ExportKeyMaterial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportKeyMaterial> {
        /**
         * <p>
         * Parameter information for key material export using symmetric TR-31 key exchange method.
         * </p>
         * 
         * @param tr31KeyBlock
         *        Parameter information for key material export using symmetric TR-31 key exchange method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock);

        /**
         * <p>
         * Parameter information for key material export using symmetric TR-31 key exchange method.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportTr31KeyBlock.Builder} avoiding the
         * need to create one manually via {@link ExportTr31KeyBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportTr31KeyBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #tr31KeyBlock(ExportTr31KeyBlock)}.
         * 
         * @param tr31KeyBlock
         *        a consumer that will call methods on {@link ExportTr31KeyBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tr31KeyBlock(ExportTr31KeyBlock)
         */
        default Builder tr31KeyBlock(Consumer<ExportTr31KeyBlock.Builder> tr31KeyBlock) {
            return tr31KeyBlock(ExportTr31KeyBlock.builder().applyMutation(tr31KeyBlock).build());
        }

        /**
         * <p>
         * Parameter information for key material export using the asymmetric TR-34 key exchange method.
         * </p>
         * 
         * @param tr34KeyBlock
         *        Parameter information for key material export using the asymmetric TR-34 key exchange method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock);

        /**
         * <p>
         * Parameter information for key material export using the asymmetric TR-34 key exchange method.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportTr34KeyBlock.Builder} avoiding the
         * need to create one manually via {@link ExportTr34KeyBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportTr34KeyBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #tr34KeyBlock(ExportTr34KeyBlock)}.
         * 
         * @param tr34KeyBlock
         *        a consumer that will call methods on {@link ExportTr34KeyBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tr34KeyBlock(ExportTr34KeyBlock)
         */
        default Builder tr34KeyBlock(Consumer<ExportTr34KeyBlock.Builder> tr34KeyBlock) {
            return tr34KeyBlock(ExportTr34KeyBlock.builder().applyMutation(tr34KeyBlock).build());
        }

        /**
         * <p>
         * Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
         * </p>
         * 
         * @param keyCryptogram
         *        Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCryptogram(ExportKeyCryptogram keyCryptogram);

        /**
         * <p>
         * Parameter information for key material export using asymmetric RSA wrap and unwrap key exchange method
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportKeyCryptogram.Builder} avoiding the
         * need to create one manually via {@link ExportKeyCryptogram#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportKeyCryptogram.Builder#build()} is called immediately and
         * its result is passed to {@link #keyCryptogram(ExportKeyCryptogram)}.
         * 
         * @param keyCryptogram
         *        a consumer that will call methods on {@link ExportKeyCryptogram.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyCryptogram(ExportKeyCryptogram)
         */
        default Builder keyCryptogram(Consumer<ExportKeyCryptogram.Builder> keyCryptogram) {
            return keyCryptogram(ExportKeyCryptogram.builder().applyMutation(keyCryptogram).build());
        }

        /**
         * <p>
         * Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
         * </p>
         * 
         * @param diffieHellmanTr31KeyBlock
         *        Key derivation parameter information for key material export using asymmetric ECDH key exchange
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock);

        /**
         * <p>
         * Key derivation parameter information for key material export using asymmetric ECDH key exchange method.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDiffieHellmanTr31KeyBlock.Builder}
         * avoiding the need to create one manually via {@link ExportDiffieHellmanTr31KeyBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDiffieHellmanTr31KeyBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock)}.
         * 
         * @param diffieHellmanTr31KeyBlock
         *        a consumer that will call methods on {@link ExportDiffieHellmanTr31KeyBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock)
         */
        default Builder diffieHellmanTr31KeyBlock(Consumer<ExportDiffieHellmanTr31KeyBlock.Builder> diffieHellmanTr31KeyBlock) {
            return diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock.builder().applyMutation(diffieHellmanTr31KeyBlock)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportTr31KeyBlock tr31KeyBlock;

        private ExportTr34KeyBlock tr34KeyBlock;

        private ExportKeyCryptogram keyCryptogram;

        private ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExportKeyMaterial model) {
            tr31KeyBlock(model.tr31KeyBlock);
            tr34KeyBlock(model.tr34KeyBlock);
            keyCryptogram(model.keyCryptogram);
            diffieHellmanTr31KeyBlock(model.diffieHellmanTr31KeyBlock);
        }

        public final ExportTr31KeyBlock.Builder getTr31KeyBlock() {
            return tr31KeyBlock != null ? tr31KeyBlock.toBuilder() : null;
        }

        public final void setTr31KeyBlock(ExportTr31KeyBlock.BuilderImpl tr31KeyBlock) {
            Object oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock != null ? tr31KeyBlock.build() : null;
            handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
        }

        @Override
        public final Builder tr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock) {
            Object oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock;
            handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
            return this;
        }

        public final ExportTr34KeyBlock.Builder getTr34KeyBlock() {
            return tr34KeyBlock != null ? tr34KeyBlock.toBuilder() : null;
        }

        public final void setTr34KeyBlock(ExportTr34KeyBlock.BuilderImpl tr34KeyBlock) {
            Object oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock != null ? tr34KeyBlock.build() : null;
            handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
        }

        @Override
        public final Builder tr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock) {
            Object oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock;
            handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
            return this;
        }

        public final ExportKeyCryptogram.Builder getKeyCryptogram() {
            return keyCryptogram != null ? keyCryptogram.toBuilder() : null;
        }

        public final void setKeyCryptogram(ExportKeyCryptogram.BuilderImpl keyCryptogram) {
            Object oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram != null ? keyCryptogram.build() : null;
            handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
        }

        @Override
        public final Builder keyCryptogram(ExportKeyCryptogram keyCryptogram) {
            Object oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram;
            handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
            return this;
        }

        public final ExportDiffieHellmanTr31KeyBlock.Builder getDiffieHellmanTr31KeyBlock() {
            return diffieHellmanTr31KeyBlock != null ? diffieHellmanTr31KeyBlock.toBuilder() : null;
        }

        public final void setDiffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock.BuilderImpl diffieHellmanTr31KeyBlock) {
            Object oldValue = this.diffieHellmanTr31KeyBlock;
            this.diffieHellmanTr31KeyBlock = diffieHellmanTr31KeyBlock != null ? diffieHellmanTr31KeyBlock.build() : null;
            handleUnionValueChange(Type.DIFFIE_HELLMAN_TR31_KEY_BLOCK, oldValue, this.diffieHellmanTr31KeyBlock);
        }

        @Override
        public final Builder diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock) {
            Object oldValue = this.diffieHellmanTr31KeyBlock;
            this.diffieHellmanTr31KeyBlock = diffieHellmanTr31KeyBlock;
            handleUnionValueChange(Type.DIFFIE_HELLMAN_TR31_KEY_BLOCK, oldValue, this.diffieHellmanTr31KeyBlock);
            return this;
        }

        @Override
        public ExportKeyMaterial build() {
            return new ExportKeyMaterial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ExportKeyMaterial#type()
     */
    public enum Type {
        TR31_KEY_BLOCK,

        TR34_KEY_BLOCK,

        KEY_CRYPTOGRAM,

        DIFFIE_HELLMAN_TR31_KEY_BLOCK,

        UNKNOWN_TO_SDK_VERSION
    }
}
