/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input parameters for enabling default key replication regions for the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableDefaultKeyReplicationRegionsRequest extends PaymentCryptographyRequest implements
        ToCopyableBuilder<EnableDefaultKeyReplicationRegionsRequest.Builder, EnableDefaultKeyReplicationRegionsRequest> {
    private static final SdkField<List<String>> REPLICATION_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationRegions")
            .getter(getter(EnableDefaultKeyReplicationRegionsRequest::replicationRegions))
            .setter(setter(Builder::replicationRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> replicationRegions;

    private EnableDefaultKeyReplicationRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.replicationRegions = builder.replicationRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationRegions() {
        return replicationRegions != null && !(replicationRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Web Services Regions to enable as default replication regions for the Amazon Web Services
     * account for <a
     * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
     * >Multi-Region key replication</a>.
     * </p>
     * <p>
     * New keys created in this account will automatically be replicated to these regions unless explicitly overridden
     * during key creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationRegions} method.
     * </p>
     * 
     * @return The list of Amazon Web Services Regions to enable as default replication regions for the Amazon Web
     *         Services account for <a href=
     *         "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
     *         >Multi-Region key replication</a>.</p>
     *         <p>
     *         New keys created in this account will automatically be replicated to these regions unless explicitly
     *         overridden during key creation.
     */
    public final List<String> replicationRegions() {
        return replicationRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationRegions() ? replicationRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableDefaultKeyReplicationRegionsRequest)) {
            return false;
        }
        EnableDefaultKeyReplicationRegionsRequest other = (EnableDefaultKeyReplicationRegionsRequest) obj;
        return hasReplicationRegions() == other.hasReplicationRegions()
                && Objects.equals(replicationRegions(), other.replicationRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableDefaultKeyReplicationRegionsRequest")
                .add("ReplicationRegions", hasReplicationRegions() ? replicationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationRegions":
            return Optional.ofNullable(clazz.cast(replicationRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationRegions", REPLICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableDefaultKeyReplicationRegionsRequest, T> g) {
        return obj -> g.apply((EnableDefaultKeyReplicationRegionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableDefaultKeyReplicationRegionsRequest> {
        /**
         * <p>
         * The list of Amazon Web Services Regions to enable as default replication regions for the Amazon Web Services
         * account for <a
         * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         * >Multi-Region key replication</a>.
         * </p>
         * <p>
         * New keys created in this account will automatically be replicated to these regions unless explicitly
         * overridden during key creation.
         * </p>
         * 
         * @param replicationRegions
         *        The list of Amazon Web Services Regions to enable as default replication regions for the Amazon Web
         *        Services account for <a href=
         *        "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         *        >Multi-Region key replication</a>.</p>
         *        <p>
         *        New keys created in this account will automatically be replicated to these regions unless explicitly
         *        overridden during key creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRegions(Collection<String> replicationRegions);

        /**
         * <p>
         * The list of Amazon Web Services Regions to enable as default replication regions for the Amazon Web Services
         * account for <a
         * href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         * >Multi-Region key replication</a>.
         * </p>
         * <p>
         * New keys created in this account will automatically be replicated to these regions unless explicitly
         * overridden during key creation.
         * </p>
         * 
         * @param replicationRegions
         *        The list of Amazon Web Services Regions to enable as default replication regions for the Amazon Web
         *        Services account for <a href=
         *        "https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html"
         *        >Multi-Region key replication</a>.</p>
         *        <p>
         *        New keys created in this account will automatically be replicated to these regions unless explicitly
         *        overridden during key creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRegions(String... replicationRegions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyRequest.BuilderImpl implements Builder {
        private List<String> replicationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableDefaultKeyReplicationRegionsRequest model) {
            super(model);
            replicationRegions(model.replicationRegions);
        }

        public final Collection<String> getReplicationRegions() {
            if (replicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationRegions;
        }

        public final void setReplicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionsCopier.copy(replicationRegions);
        }

        @Override
        public final Builder replicationRegions(Collection<String> replicationRegions) {
            this.replicationRegions = RegionsCopier.copy(replicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRegions(String... replicationRegions) {
            replicationRegions(Arrays.asList(replicationRegions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableDefaultKeyReplicationRegionsRequest build() {
            return new EnableDefaultKeyReplicationRegionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
