/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output from disabling default key replication regions for the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableDefaultKeyReplicationRegionsResponse extends PaymentCryptographyResponse implements
        ToCopyableBuilder<DisableDefaultKeyReplicationRegionsResponse.Builder, DisableDefaultKeyReplicationRegionsResponse> {
    private static final SdkField<List<String>> ENABLED_REPLICATION_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledReplicationRegions")
            .getter(getter(DisableDefaultKeyReplicationRegionsResponse::enabledReplicationRegions))
            .setter(setter(Builder::enabledReplicationRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledReplicationRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLED_REPLICATION_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> enabledReplicationRegions;

    private DisableDefaultKeyReplicationRegionsResponse(BuilderImpl builder) {
        super(builder);
        this.enabledReplicationRegions = builder.enabledReplicationRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledReplicationRegions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledReplicationRegions() {
        return enabledReplicationRegions != null && !(enabledReplicationRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The remaining list of regions where default key replication is still enabled for the account.
     * </p>
     * <p>
     * This reflects the account's default replication configuration after removing the specified regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledReplicationRegions} method.
     * </p>
     * 
     * @return The remaining list of regions where default key replication is still enabled for the account.</p>
     *         <p>
     *         This reflects the account's default replication configuration after removing the specified regions.
     */
    public final List<String> enabledReplicationRegions() {
        return enabledReplicationRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledReplicationRegions() ? enabledReplicationRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableDefaultKeyReplicationRegionsResponse)) {
            return false;
        }
        DisableDefaultKeyReplicationRegionsResponse other = (DisableDefaultKeyReplicationRegionsResponse) obj;
        return hasEnabledReplicationRegions() == other.hasEnabledReplicationRegions()
                && Objects.equals(enabledReplicationRegions(), other.enabledReplicationRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableDefaultKeyReplicationRegionsResponse")
                .add("EnabledReplicationRegions", hasEnabledReplicationRegions() ? enabledReplicationRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledReplicationRegions":
            return Optional.ofNullable(clazz.cast(enabledReplicationRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnabledReplicationRegions", ENABLED_REPLICATION_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableDefaultKeyReplicationRegionsResponse, T> g) {
        return obj -> g.apply((DisableDefaultKeyReplicationRegionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisableDefaultKeyReplicationRegionsResponse> {
        /**
         * <p>
         * The remaining list of regions where default key replication is still enabled for the account.
         * </p>
         * <p>
         * This reflects the account's default replication configuration after removing the specified regions.
         * </p>
         * 
         * @param enabledReplicationRegions
         *        The remaining list of regions where default key replication is still enabled for the account.</p>
         *        <p>
         *        This reflects the account's default replication configuration after removing the specified regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledReplicationRegions(Collection<String> enabledReplicationRegions);

        /**
         * <p>
         * The remaining list of regions where default key replication is still enabled for the account.
         * </p>
         * <p>
         * This reflects the account's default replication configuration after removing the specified regions.
         * </p>
         * 
         * @param enabledReplicationRegions
         *        The remaining list of regions where default key replication is still enabled for the account.</p>
         *        <p>
         *        This reflects the account's default replication configuration after removing the specified regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledReplicationRegions(String... enabledReplicationRegions);
    }

    static final class BuilderImpl extends PaymentCryptographyResponse.BuilderImpl implements Builder {
        private List<String> enabledReplicationRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableDefaultKeyReplicationRegionsResponse model) {
            super(model);
            enabledReplicationRegions(model.enabledReplicationRegions);
        }

        public final Collection<String> getEnabledReplicationRegions() {
            if (enabledReplicationRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledReplicationRegions;
        }

        public final void setEnabledReplicationRegions(Collection<String> enabledReplicationRegions) {
            this.enabledReplicationRegions = RegionsCopier.copy(enabledReplicationRegions);
        }

        @Override
        public final Builder enabledReplicationRegions(Collection<String> enabledReplicationRegions) {
            this.enabledReplicationRegions = RegionsCopier.copy(enabledReplicationRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledReplicationRegions(String... enabledReplicationRegions) {
            enabledReplicationRegions(Arrays.asList(enabledReplicationRegions));
            return this;
        }

        @Override
        public DisableDefaultKeyReplicationRegionsResponse build() {
            return new DisableDefaultKeyReplicationRegionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
