/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DeriveKeyUsage {
    TR31_B0_BASE_DERIVATION_KEY("TR31_B0_BASE_DERIVATION_KEY"),

    TR31_C0_CARD_VERIFICATION_KEY("TR31_C0_CARD_VERIFICATION_KEY"),

    TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY("TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY"),

    TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS("TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS"),

    TR31_E1_EMV_MKEY_CONFIDENTIALITY("TR31_E1_EMV_MKEY_CONFIDENTIALITY"),

    TR31_E2_EMV_MKEY_INTEGRITY("TR31_E2_EMV_MKEY_INTEGRITY"),

    TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS("TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS"),

    TR31_E5_EMV_MKEY_CARD_PERSONALIZATION("TR31_E5_EMV_MKEY_CARD_PERSONALIZATION"),

    TR31_E6_EMV_MKEY_OTHER("TR31_E6_EMV_MKEY_OTHER"),

    TR31_K0_KEY_ENCRYPTION_KEY("TR31_K0_KEY_ENCRYPTION_KEY"),

    TR31_K1_KEY_BLOCK_PROTECTION_KEY("TR31_K1_KEY_BLOCK_PROTECTION_KEY"),

    TR31_M3_ISO_9797_3_MAC_KEY("TR31_M3_ISO_9797_3_MAC_KEY"),

    TR31_M1_ISO_9797_1_MAC_KEY("TR31_M1_ISO_9797_1_MAC_KEY"),

    TR31_M6_ISO_9797_5_CMAC_KEY("TR31_M6_ISO_9797_5_CMAC_KEY"),

    TR31_M7_HMAC_KEY("TR31_M7_HMAC_KEY"),

    TR31_P0_PIN_ENCRYPTION_KEY("TR31_P0_PIN_ENCRYPTION_KEY"),

    TR31_P1_PIN_GENERATION_KEY("TR31_P1_PIN_GENERATION_KEY"),

    TR31_V1_IBM3624_PIN_VERIFICATION_KEY("TR31_V1_IBM3624_PIN_VERIFICATION_KEY"),

    TR31_V2_VISA_PIN_VERIFICATION_KEY("TR31_V2_VISA_PIN_VERIFICATION_KEY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeriveKeyUsage> VALUE_MAP = EnumUtils.uniqueIndex(DeriveKeyUsage.class,
            DeriveKeyUsage::toString);

    private final String value;

    private DeriveKeyUsage(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DeriveKeyUsage corresponding to the value
     */
    public static DeriveKeyUsage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DeriveKeyUsage}s
     */
    public static Set<DeriveKeyUsage> knownValues() {
        Set<DeriveKeyUsage> knownValues = EnumSet.allOf(DeriveKeyUsage.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
