/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.paymentcryptography.model.DeriveKeyUsage;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes;
import software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.services.paymentcryptography.model.Tag;
import software.amazon.awssdk.services.paymentcryptography.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, CreateKeyRequest> {
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyAttributes").getter(CreateKeyRequest.getter(CreateKeyRequest::keyAttributes)).setter(CreateKeyRequest.setter(Builder::keyAttributes)).constructor(KeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(CreateKeyRequest.getter(CreateKeyRequest::keyCheckValueAlgorithmAsString)).setter(CreateKeyRequest.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exportable").getter(CreateKeyRequest.getter(CreateKeyRequest::exportable)).setter(CreateKeyRequest.setter(Builder::exportable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exportable").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CreateKeyRequest.getter(CreateKeyRequest::enabled)).setter(CreateKeyRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateKeyRequest.getter(CreateKeyRequest::tags)).setter(CreateKeyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DERIVE_KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeriveKeyUsage").getter(CreateKeyRequest.getter(CreateKeyRequest::deriveKeyUsageAsString)).setter(CreateKeyRequest.setter(Builder::deriveKeyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeriveKeyUsage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD, EXPORTABLE_FIELD, ENABLED_FIELD, TAGS_FIELD, DERIVE_KEY_USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateKeyRequest.memberNameToFieldInitializer();
    private final KeyAttributes keyAttributes;
    private final String keyCheckValueAlgorithm;
    private final Boolean exportable;
    private final Boolean enabled;
    private final List<Tag> tags;
    private final String deriveKeyUsage;

    private CreateKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyAttributes = builder.keyAttributes;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
        this.exportable = builder.exportable;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
        this.deriveKeyUsage = builder.deriveKeyUsage;
    }

    public final KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    public final Boolean exportable() {
        return this.exportable;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final DeriveKeyUsage deriveKeyUsage() {
        return DeriveKeyUsage.fromValue(this.deriveKeyUsage);
    }

    public final String deriveKeyUsageAsString() {
        return this.deriveKeyUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportable());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deriveKeyUsageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyRequest)) {
            return false;
        }
        CreateKeyRequest other = (CreateKeyRequest)((Object)obj);
        return Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString()) && Objects.equals(this.exportable(), other.exportable()) && Objects.equals(this.enabled(), other.enabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.deriveKeyUsageAsString(), other.deriveKeyUsageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyRequest").add("KeyAttributes", (Object)this.keyAttributes()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).add("Exportable", (Object)this.exportable()).add("Enabled", (Object)this.enabled()).add("Tags", this.hasTags() ? this.tags() : null).add("DeriveKeyUsage", (Object)this.deriveKeyUsageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
            case "Exportable": {
                return Optional.ofNullable(clazz.cast(this.exportable()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DeriveKeyUsage": {
                return Optional.ofNullable(clazz.cast(this.deriveKeyUsageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        map.put("Exportable", EXPORTABLE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DeriveKeyUsage", DERIVE_KEY_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyRequest, T> g) {
        return obj -> g.apply((CreateKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private KeyAttributes keyAttributes;
        private String keyCheckValueAlgorithm;
        private Boolean exportable;
        private Boolean enabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String deriveKeyUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyRequest model) {
            super(model);
            this.keyAttributes(model.keyAttributes);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
            this.exportable(model.exportable);
            this.enabled(model.enabled);
            this.tags(model.tags);
            this.deriveKeyUsage(model.deriveKeyUsage);
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return this.keyAttributes != null ? this.keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        public final Boolean getExportable() {
            return this.exportable;
        }

        public final void setExportable(Boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public final Builder exportable(Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDeriveKeyUsage() {
            return this.deriveKeyUsage;
        }

        public final void setDeriveKeyUsage(String deriveKeyUsage) {
            this.deriveKeyUsage = deriveKeyUsage;
        }

        @Override
        public final Builder deriveKeyUsage(String deriveKeyUsage) {
            this.deriveKeyUsage = deriveKeyUsage;
            return this;
        }

        @Override
        public final Builder deriveKeyUsage(DeriveKeyUsage deriveKeyUsage) {
            this.deriveKeyUsage(deriveKeyUsage == null ? null : deriveKeyUsage.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyRequest build() {
            return new CreateKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyRequest> {
        public Builder keyAttributes(KeyAttributes var1);

        default public Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return this.keyAttributes((KeyAttributes)((KeyAttributes.Builder)KeyAttributes.builder().applyMutation(keyAttributes)).build());
        }

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);

        public Builder exportable(Boolean var1);

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder deriveKeyUsage(String var1);

        public Builder deriveKeyUsage(DeriveKeyUsage var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

