/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.paymentcryptography.DefaultPaymentCryptographyBaseClientBuilder;
import software.amazon.awssdk.services.paymentcryptography.DefaultPaymentCryptographyClient;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyClient;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyClientBuilder;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyServiceClientConfiguration;
import software.amazon.awssdk.services.paymentcryptography.endpoints.PaymentCryptographyEndpointProvider;

@SdkInternalApi
final class DefaultPaymentCryptographyClientBuilder
extends DefaultPaymentCryptographyBaseClientBuilder<PaymentCryptographyClientBuilder, PaymentCryptographyClient>
implements PaymentCryptographyClientBuilder {
    DefaultPaymentCryptographyClientBuilder() {
    }

    @Override
    public DefaultPaymentCryptographyClientBuilder endpointProvider(PaymentCryptographyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PaymentCryptographyClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPaymentCryptographyClientBuilder.validateClientOptions(clientConfiguration);
        PaymentCryptographyServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPaymentCryptographyClient client = new DefaultPaymentCryptographyClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PaymentCryptographyServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PaymentCryptographyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

