/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTasksResponse;

public class ListOpportunityFromEngagementTasksPublisher
implements SdkPublisher<ListOpportunityFromEngagementTasksResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListOpportunityFromEngagementTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpportunityFromEngagementTasksPublisher(PartnerCentralSellingAsyncClient client, ListOpportunityFromEngagementTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpportunityFromEngagementTasksPublisher(PartnerCentralSellingAsyncClient client, ListOpportunityFromEngagementTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpportunityFromEngagementTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpportunityFromEngagementTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListOpportunityFromEngagementTaskSummary> taskSummaries() {
        Function<ListOpportunityFromEngagementTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskSummaries() != null) {
                return response.taskSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpportunityFromEngagementTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpportunityFromEngagementTasksResponseFetcher
    implements AsyncPageFetcher<ListOpportunityFromEngagementTasksResponse> {
        private ListOpportunityFromEngagementTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListOpportunityFromEngagementTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOpportunityFromEngagementTasksResponse> nextPage(ListOpportunityFromEngagementTasksResponse previousPage) {
            if (previousPage == null) {
                return ListOpportunityFromEngagementTasksPublisher.this.client.listOpportunityFromEngagementTasks(ListOpportunityFromEngagementTasksPublisher.this.firstRequest);
            }
            return ListOpportunityFromEngagementTasksPublisher.this.client.listOpportunityFromEngagementTasks((ListOpportunityFromEngagementTasksRequest)((Object)ListOpportunityFromEngagementTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

