/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTaskSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunityFromEngagementTasksResponse;

public class ListOpportunityFromEngagementTasksIterable
implements SdkIterable<ListOpportunityFromEngagementTasksResponse> {
    private final PartnerCentralSellingClient client;
    private final ListOpportunityFromEngagementTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOpportunityFromEngagementTasksIterable(PartnerCentralSellingClient client, ListOpportunityFromEngagementTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOpportunityFromEngagementTasksResponseFetcher();
    }

    public Iterator<ListOpportunityFromEngagementTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListOpportunityFromEngagementTaskSummary> taskSummaries() {
        Function<ListOpportunityFromEngagementTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskSummaries() != null) {
                return response.taskSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOpportunityFromEngagementTasksResponseFetcher
    implements SyncPageFetcher<ListOpportunityFromEngagementTasksResponse> {
        private ListOpportunityFromEngagementTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListOpportunityFromEngagementTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOpportunityFromEngagementTasksResponse nextPage(ListOpportunityFromEngagementTasksResponse previousPage) {
            if (previousPage == null) {
                return ListOpportunityFromEngagementTasksIterable.this.client.listOpportunityFromEngagementTasks(ListOpportunityFromEngagementTasksIterable.this.firstRequest);
            }
            return ListOpportunityFromEngagementTasksIterable.this.client.listOpportunityFromEngagementTasks((ListOpportunityFromEngagementTasksRequest)((Object)ListOpportunityFromEngagementTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

