/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MarketSegment {
    ENTERPRISE("Enterprise"),
    LARGE("Large"),
    MEDIUM("Medium"),
    SMALL("Small"),
    MICRO("Micro"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MarketSegment> VALUE_MAP;
    private final String value;

    private MarketSegment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MarketSegment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MarketSegment> knownValues() {
        EnumSet<MarketSegment> knownValues = EnumSet.allOf(MarketSegment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MarketSegment.class, MarketSegment::toString);
    }
}

