/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.CountryCode;
import software.amazon.awssdk.services.partnercentralselling.model.Industry;
import software.amazon.awssdk.services.partnercentralselling.model.MarketSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LeadInvitationCustomer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LeadInvitationCustomer> {
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(LeadInvitationCustomer.getter(LeadInvitationCustomer::industryAsString)).setter(LeadInvitationCustomer.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(LeadInvitationCustomer.getter(LeadInvitationCustomer::companyName)).setter(LeadInvitationCustomer.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteUrl").getter(LeadInvitationCustomer.getter(LeadInvitationCustomer::websiteUrl)).setter(LeadInvitationCustomer.setter(Builder::websiteUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(LeadInvitationCustomer.getter(LeadInvitationCustomer::countryCodeAsString)).setter(LeadInvitationCustomer.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> AWS_MATURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsMaturity").getter(LeadInvitationCustomer.getter(LeadInvitationCustomer::awsMaturity)).setter(LeadInvitationCustomer.setter(Builder::awsMaturity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsMaturity").build()}).build();
    private static final SdkField<String> MARKET_SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarketSegment").getter(LeadInvitationCustomer.getter(LeadInvitationCustomer::marketSegmentAsString)).setter(LeadInvitationCustomer.setter(Builder::marketSegment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketSegment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDUSTRY_FIELD, COMPANY_NAME_FIELD, WEBSITE_URL_FIELD, COUNTRY_CODE_FIELD, AWS_MATURITY_FIELD, MARKET_SEGMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LeadInvitationCustomer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String industry;
    private final String companyName;
    private final String websiteUrl;
    private final String countryCode;
    private final String awsMaturity;
    private final String marketSegment;

    private LeadInvitationCustomer(BuilderImpl builder) {
        this.industry = builder.industry;
        this.companyName = builder.companyName;
        this.websiteUrl = builder.websiteUrl;
        this.countryCode = builder.countryCode;
        this.awsMaturity = builder.awsMaturity;
        this.marketSegment = builder.marketSegment;
    }

    public final Industry industry() {
        return Industry.fromValue(this.industry);
    }

    public final String industryAsString() {
        return this.industry;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String websiteUrl() {
        return this.websiteUrl;
    }

    public final CountryCode countryCode() {
        return CountryCode.fromValue(this.countryCode);
    }

    public final String countryCodeAsString() {
        return this.countryCode;
    }

    public final String awsMaturity() {
        return this.awsMaturity;
    }

    public final MarketSegment marketSegment() {
        return MarketSegment.fromValue(this.marketSegment);
    }

    public final String marketSegmentAsString() {
        return this.marketSegment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsMaturity());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketSegmentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LeadInvitationCustomer)) {
            return false;
        }
        LeadInvitationCustomer other = (LeadInvitationCustomer)obj;
        return Objects.equals(this.industryAsString(), other.industryAsString()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.websiteUrl(), other.websiteUrl()) && Objects.equals(this.countryCodeAsString(), other.countryCodeAsString()) && Objects.equals(this.awsMaturity(), other.awsMaturity()) && Objects.equals(this.marketSegmentAsString(), other.marketSegmentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LeadInvitationCustomer").add("Industry", (Object)this.industryAsString()).add("CompanyName", (Object)(this.companyName() == null ? null : "*** Sensitive Data Redacted ***")).add("WebsiteUrl", (Object)(this.websiteUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("CountryCode", (Object)(this.countryCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("AwsMaturity", (Object)this.awsMaturity()).add("MarketSegment", (Object)this.marketSegmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industryAsString()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "WebsiteUrl": {
                return Optional.ofNullable(clazz.cast(this.websiteUrl()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCodeAsString()));
            }
            case "AwsMaturity": {
                return Optional.ofNullable(clazz.cast(this.awsMaturity()));
            }
            case "MarketSegment": {
                return Optional.ofNullable(clazz.cast(this.marketSegmentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Industry", INDUSTRY_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("AwsMaturity", AWS_MATURITY_FIELD);
        map.put("MarketSegment", MARKET_SEGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LeadInvitationCustomer, T> g) {
        return obj -> g.apply((LeadInvitationCustomer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String industry;
        private String companyName;
        private String websiteUrl;
        private String countryCode;
        private String awsMaturity;
        private String marketSegment;

        private BuilderImpl() {
        }

        private BuilderImpl(LeadInvitationCustomer model) {
            this.industry(model.industry);
            this.companyName(model.companyName);
            this.websiteUrl(model.websiteUrl);
            this.countryCode(model.countryCode);
            this.awsMaturity(model.awsMaturity);
            this.marketSegment(model.marketSegment);
        }

        public final String getIndustry() {
            return this.industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final String getAwsMaturity() {
            return this.awsMaturity;
        }

        public final void setAwsMaturity(String awsMaturity) {
            this.awsMaturity = awsMaturity;
        }

        @Override
        public final Builder awsMaturity(String awsMaturity) {
            this.awsMaturity = awsMaturity;
            return this;
        }

        public final String getMarketSegment() {
            return this.marketSegment;
        }

        public final void setMarketSegment(String marketSegment) {
            this.marketSegment = marketSegment;
        }

        @Override
        public final Builder marketSegment(String marketSegment) {
            this.marketSegment = marketSegment;
            return this;
        }

        @Override
        public final Builder marketSegment(MarketSegment marketSegment) {
            this.marketSegment(marketSegment == null ? null : marketSegment.toString());
            return this;
        }

        public LeadInvitationCustomer build() {
            return new LeadInvitationCustomer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LeadInvitationCustomer> {
        public Builder industry(String var1);

        public Builder industry(Industry var1);

        public Builder companyName(String var1);

        public Builder websiteUrl(String var1);

        public Builder countryCode(String var1);

        public Builder countryCode(CountryCode var1);

        public Builder awsMaturity(String var1);

        public Builder marketSegment(String var1);

        public Builder marketSegment(MarketSegment var1);
    }
}

