/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.LeadCustomer;
import software.amazon.awssdk.services.partnercentralselling.model.LeadInteraction;
import software.amazon.awssdk.services.partnercentralselling.model.LeadInteractionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LeadContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LeadContext> {
    private static final SdkField<String> QUALIFICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualificationStatus").getter(LeadContext.getter(LeadContext::qualificationStatus)).setter(LeadContext.setter(Builder::qualificationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationStatus").build()}).build();
    private static final SdkField<LeadCustomer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(LeadContext.getter(LeadContext::customer)).setter(LeadContext.setter(Builder::customer)).constructor(LeadCustomer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<List<LeadInteraction>> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Interactions").getter(LeadContext.getter(LeadContext::interactions)).setter(LeadContext.setter(Builder::interactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LeadInteraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_STATUS_FIELD, CUSTOMER_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LeadContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String qualificationStatus;
    private final LeadCustomer customer;
    private final List<LeadInteraction> interactions;

    private LeadContext(BuilderImpl builder) {
        this.qualificationStatus = builder.qualificationStatus;
        this.customer = builder.customer;
        this.interactions = builder.interactions;
    }

    public final String qualificationStatus() {
        return this.qualificationStatus;
    }

    public final LeadCustomer customer() {
        return this.customer;
    }

    public final boolean hasInteractions() {
        return this.interactions != null && !(this.interactions instanceof SdkAutoConstructList);
    }

    public final List<LeadInteraction> interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInteractions() ? this.interactions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LeadContext)) {
            return false;
        }
        LeadContext other = (LeadContext)obj;
        return Objects.equals(this.qualificationStatus(), other.qualificationStatus()) && Objects.equals(this.customer(), other.customer()) && this.hasInteractions() == other.hasInteractions() && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"LeadContext").add("QualificationStatus", (Object)this.qualificationStatus()).add("Customer", (Object)this.customer()).add("Interactions", this.hasInteractions() ? this.interactions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualificationStatus": {
                return Optional.ofNullable(clazz.cast(this.qualificationStatus()));
            }
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QualificationStatus", QUALIFICATION_STATUS_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LeadContext, T> g) {
        return obj -> g.apply((LeadContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String qualificationStatus;
        private LeadCustomer customer;
        private List<LeadInteraction> interactions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LeadContext model) {
            this.qualificationStatus(model.qualificationStatus);
            this.customer(model.customer);
            this.interactions(model.interactions);
        }

        public final String getQualificationStatus() {
            return this.qualificationStatus;
        }

        public final void setQualificationStatus(String qualificationStatus) {
            this.qualificationStatus = qualificationStatus;
        }

        @Override
        public final Builder qualificationStatus(String qualificationStatus) {
            this.qualificationStatus = qualificationStatus;
            return this;
        }

        public final LeadCustomer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(LeadCustomer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(LeadCustomer customer) {
            this.customer = customer;
            return this;
        }

        public final List<LeadInteraction.Builder> getInteractions() {
            List<LeadInteraction.Builder> result = LeadInteractionListCopier.copyToBuilder(this.interactions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInteractions(Collection<LeadInteraction.BuilderImpl> interactions) {
            this.interactions = LeadInteractionListCopier.copyFromBuilder(interactions);
        }

        @Override
        public final Builder interactions(Collection<LeadInteraction> interactions) {
            this.interactions = LeadInteractionListCopier.copy(interactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interactions(LeadInteraction ... interactions) {
            this.interactions(Arrays.asList(interactions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interactions(Consumer<LeadInteraction.Builder> ... interactions) {
            this.interactions(Stream.of(interactions).map(c -> (LeadInteraction)((LeadInteraction.Builder)LeadInteraction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LeadContext build() {
            return new LeadContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LeadContext> {
        public Builder qualificationStatus(String var1);

        public Builder customer(LeadCustomer var1);

        default public Builder customer(Consumer<LeadCustomer.Builder> customer) {
            return this.customer((LeadCustomer)((LeadCustomer.Builder)LeadCustomer.builder().applyMutation(customer)).build());
        }

        public Builder interactions(Collection<LeadInteraction> var1);

        public Builder interactions(LeadInteraction ... var1);

        public Builder interactions(Consumer<LeadInteraction.Builder> ... var1);
    }
}

