/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralselling.model.AmountMapCopier;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductDetails;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductInsightsCurrencyCodeEnum;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductsListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PaymentFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsProductInsights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsProductInsights> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(AwsProductInsights.getter(AwsProductInsights::currencyCodeAsString)).setter(AwsProductInsights.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Frequency").getter(AwsProductInsights.getter(AwsProductInsights::frequencyAsString)).setter(AwsProductInsights.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<String> TOTAL_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalAmount").getter(AwsProductInsights.getter(AwsProductInsights::totalAmount)).setter(AwsProductInsights.setter(Builder::totalAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmount").build()}).build();
    private static final SdkField<String> TOTAL_OPTIMIZED_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalOptimizedAmount").getter(AwsProductInsights.getter(AwsProductInsights::totalOptimizedAmount)).setter(AwsProductInsights.setter(Builder::totalOptimizedAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalOptimizedAmount").build()}).build();
    private static final SdkField<String> TOTAL_POTENTIAL_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalPotentialSavingsAmount").getter(AwsProductInsights.getter(AwsProductInsights::totalPotentialSavingsAmount)).setter(AwsProductInsights.setter(Builder::totalPotentialSavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPotentialSavingsAmount").build()}).build();
    private static final SdkField<Map<String, String>> TOTAL_AMOUNT_BY_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TotalAmountByCategory").getter(AwsProductInsights.getter(AwsProductInsights::totalAmountByCategory)).setter(AwsProductInsights.setter(Builder::totalAmountByCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAmountByCategory").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AwsProductDetails>> AWS_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsProducts").getter(AwsProductInsights.getter(AwsProductInsights::awsProducts)).setter(AwsProductInsights.setter(Builder::awsProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsProductDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, FREQUENCY_FIELD, TOTAL_AMOUNT_FIELD, TOTAL_OPTIMIZED_AMOUNT_FIELD, TOTAL_POTENTIAL_SAVINGS_AMOUNT_FIELD, TOTAL_AMOUNT_BY_CATEGORY_FIELD, AWS_PRODUCTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsProductInsights.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final String frequency;
    private final String totalAmount;
    private final String totalOptimizedAmount;
    private final String totalPotentialSavingsAmount;
    private final Map<String, String> totalAmountByCategory;
    private final List<AwsProductDetails> awsProducts;

    private AwsProductInsights(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.frequency = builder.frequency;
        this.totalAmount = builder.totalAmount;
        this.totalOptimizedAmount = builder.totalOptimizedAmount;
        this.totalPotentialSavingsAmount = builder.totalPotentialSavingsAmount;
        this.totalAmountByCategory = builder.totalAmountByCategory;
        this.awsProducts = builder.awsProducts;
    }

    public final AwsProductInsightsCurrencyCodeEnum currencyCode() {
        return AwsProductInsightsCurrencyCodeEnum.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final PaymentFrequency frequency() {
        return PaymentFrequency.fromValue(this.frequency);
    }

    public final String frequencyAsString() {
        return this.frequency;
    }

    public final String totalAmount() {
        return this.totalAmount;
    }

    public final String totalOptimizedAmount() {
        return this.totalOptimizedAmount;
    }

    public final String totalPotentialSavingsAmount() {
        return this.totalPotentialSavingsAmount;
    }

    public final boolean hasTotalAmountByCategory() {
        return this.totalAmountByCategory != null && !(this.totalAmountByCategory instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> totalAmountByCategory() {
        return this.totalAmountByCategory;
    }

    public final boolean hasAwsProducts() {
        return this.awsProducts != null && !(this.awsProducts instanceof SdkAutoConstructList);
    }

    public final List<AwsProductDetails> awsProducts() {
        return this.awsProducts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalOptimizedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPotentialSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTotalAmountByCategory() ? this.totalAmountByCategory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsProducts() ? this.awsProducts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsProductInsights)) {
            return false;
        }
        AwsProductInsights other = (AwsProductInsights)obj;
        return Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.totalAmount(), other.totalAmount()) && Objects.equals(this.totalOptimizedAmount(), other.totalOptimizedAmount()) && Objects.equals(this.totalPotentialSavingsAmount(), other.totalPotentialSavingsAmount()) && this.hasTotalAmountByCategory() == other.hasTotalAmountByCategory() && Objects.equals(this.totalAmountByCategory(), other.totalAmountByCategory()) && this.hasAwsProducts() == other.hasAwsProducts() && Objects.equals(this.awsProducts(), other.awsProducts());
    }

    public final String toString() {
        return ToString.builder((String)"AwsProductInsights").add("CurrencyCode", (Object)(this.currencyCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Frequency", (Object)this.frequencyAsString()).add("TotalAmount", (Object)(this.totalAmount() == null ? null : "*** Sensitive Data Redacted ***")).add("TotalOptimizedAmount", (Object)(this.totalOptimizedAmount() == null ? null : "*** Sensitive Data Redacted ***")).add("TotalPotentialSavingsAmount", (Object)(this.totalPotentialSavingsAmount() == null ? null : "*** Sensitive Data Redacted ***")).add("TotalAmountByCategory", (Object)(this.totalAmountByCategory() == null ? null : "*** Sensitive Data Redacted ***")).add("AwsProducts", this.hasAwsProducts() ? this.awsProducts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "TotalAmount": {
                return Optional.ofNullable(clazz.cast(this.totalAmount()));
            }
            case "TotalOptimizedAmount": {
                return Optional.ofNullable(clazz.cast(this.totalOptimizedAmount()));
            }
            case "TotalPotentialSavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.totalPotentialSavingsAmount()));
            }
            case "TotalAmountByCategory": {
                return Optional.ofNullable(clazz.cast(this.totalAmountByCategory()));
            }
            case "AwsProducts": {
                return Optional.ofNullable(clazz.cast(this.awsProducts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Frequency", FREQUENCY_FIELD);
        map.put("TotalAmount", TOTAL_AMOUNT_FIELD);
        map.put("TotalOptimizedAmount", TOTAL_OPTIMIZED_AMOUNT_FIELD);
        map.put("TotalPotentialSavingsAmount", TOTAL_POTENTIAL_SAVINGS_AMOUNT_FIELD);
        map.put("TotalAmountByCategory", TOTAL_AMOUNT_BY_CATEGORY_FIELD);
        map.put("AwsProducts", AWS_PRODUCTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsProductInsights, T> g) {
        return obj -> g.apply((AwsProductInsights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private String frequency;
        private String totalAmount;
        private String totalOptimizedAmount;
        private String totalPotentialSavingsAmount;
        private Map<String, String> totalAmountByCategory = DefaultSdkAutoConstructMap.getInstance();
        private List<AwsProductDetails> awsProducts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsProductInsights model) {
            this.currencyCode(model.currencyCode);
            this.frequency(model.frequency);
            this.totalAmount(model.totalAmount);
            this.totalOptimizedAmount(model.totalOptimizedAmount);
            this.totalPotentialSavingsAmount(model.totalPotentialSavingsAmount);
            this.totalAmountByCategory(model.totalAmountByCategory);
            this.awsProducts(model.awsProducts);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(AwsProductInsightsCurrencyCodeEnum currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(PaymentFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getTotalAmount() {
            return this.totalAmount;
        }

        public final void setTotalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
        }

        @Override
        public final Builder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public final String getTotalOptimizedAmount() {
            return this.totalOptimizedAmount;
        }

        public final void setTotalOptimizedAmount(String totalOptimizedAmount) {
            this.totalOptimizedAmount = totalOptimizedAmount;
        }

        @Override
        public final Builder totalOptimizedAmount(String totalOptimizedAmount) {
            this.totalOptimizedAmount = totalOptimizedAmount;
            return this;
        }

        public final String getTotalPotentialSavingsAmount() {
            return this.totalPotentialSavingsAmount;
        }

        public final void setTotalPotentialSavingsAmount(String totalPotentialSavingsAmount) {
            this.totalPotentialSavingsAmount = totalPotentialSavingsAmount;
        }

        @Override
        public final Builder totalPotentialSavingsAmount(String totalPotentialSavingsAmount) {
            this.totalPotentialSavingsAmount = totalPotentialSavingsAmount;
            return this;
        }

        public final Map<String, String> getTotalAmountByCategory() {
            if (this.totalAmountByCategory instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.totalAmountByCategory;
        }

        public final void setTotalAmountByCategory(Map<String, String> totalAmountByCategory) {
            this.totalAmountByCategory = AmountMapCopier.copy(totalAmountByCategory);
        }

        @Override
        public final Builder totalAmountByCategory(Map<String, String> totalAmountByCategory) {
            this.totalAmountByCategory = AmountMapCopier.copy(totalAmountByCategory);
            return this;
        }

        public final List<AwsProductDetails.Builder> getAwsProducts() {
            List<AwsProductDetails.Builder> result = AwsProductsListCopier.copyToBuilder(this.awsProducts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAwsProducts(Collection<AwsProductDetails.BuilderImpl> awsProducts) {
            this.awsProducts = AwsProductsListCopier.copyFromBuilder(awsProducts);
        }

        @Override
        public final Builder awsProducts(Collection<AwsProductDetails> awsProducts) {
            this.awsProducts = AwsProductsListCopier.copy(awsProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsProducts(AwsProductDetails ... awsProducts) {
            this.awsProducts(Arrays.asList(awsProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsProducts(Consumer<AwsProductDetails.Builder> ... awsProducts) {
            this.awsProducts(Stream.of(awsProducts).map(c -> (AwsProductDetails)((AwsProductDetails.Builder)AwsProductDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsProductInsights build() {
            return new AwsProductInsights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsProductInsights> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(AwsProductInsightsCurrencyCodeEnum var1);

        public Builder frequency(String var1);

        public Builder frequency(PaymentFrequency var1);

        public Builder totalAmount(String var1);

        public Builder totalOptimizedAmount(String var1);

        public Builder totalPotentialSavingsAmount(String var1);

        public Builder totalAmountByCategory(Map<String, String> var1);

        public Builder awsProducts(Collection<AwsProductDetails> var1);

        public Builder awsProducts(AwsProductDetails ... var1);

        public Builder awsProducts(Consumer<AwsProductDetails.Builder> ... var1);
    }
}

