/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductDetailsCategoriesListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductOptimization;
import software.amazon.awssdk.services.partnercentralselling.model.AwsProductOptimizationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsProductDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsProductDetails> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(AwsProductDetails.getter(AwsProductDetails::productCode)).setter(AwsProductDetails.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(AwsProductDetails.getter(AwsProductDetails::serviceCode)).setter(AwsProductDetails.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(AwsProductDetails.getter(AwsProductDetails::categories)).setter(AwsProductDetails.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Amount").getter(AwsProductDetails.getter(AwsProductDetails::amount)).setter(AwsProductDetails.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> OPTIMIZED_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizedAmount").getter(AwsProductDetails.getter(AwsProductDetails::optimizedAmount)).setter(AwsProductDetails.setter(Builder::optimizedAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizedAmount").build()}).build();
    private static final SdkField<String> POTENTIAL_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PotentialSavingsAmount").getter(AwsProductDetails.getter(AwsProductDetails::potentialSavingsAmount)).setter(AwsProductDetails.setter(Builder::potentialSavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PotentialSavingsAmount").build()}).build();
    private static final SdkField<List<AwsProductOptimization>> OPTIMIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Optimizations").getter(AwsProductDetails.getter(AwsProductDetails::optimizations)).setter(AwsProductDetails.setter(Builder::optimizations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Optimizations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsProductOptimization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD, SERVICE_CODE_FIELD, CATEGORIES_FIELD, AMOUNT_FIELD, OPTIMIZED_AMOUNT_FIELD, POTENTIAL_SAVINGS_AMOUNT_FIELD, OPTIMIZATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsProductDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String productCode;
    private final String serviceCode;
    private final List<String> categories;
    private final String amount;
    private final String optimizedAmount;
    private final String potentialSavingsAmount;
    private final List<AwsProductOptimization> optimizations;

    private AwsProductDetails(BuilderImpl builder) {
        this.productCode = builder.productCode;
        this.serviceCode = builder.serviceCode;
        this.categories = builder.categories;
        this.amount = builder.amount;
        this.optimizedAmount = builder.optimizedAmount;
        this.potentialSavingsAmount = builder.potentialSavingsAmount;
        this.optimizations = builder.optimizations;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    public final String amount() {
        return this.amount;
    }

    public final String optimizedAmount() {
        return this.optimizedAmount;
    }

    public final String potentialSavingsAmount() {
        return this.potentialSavingsAmount;
    }

    public final boolean hasOptimizations() {
        return this.optimizations != null && !(this.optimizations instanceof SdkAutoConstructList);
    }

    public final List<AwsProductOptimization> optimizations() {
        return this.optimizations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizedAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.potentialSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizations() ? this.optimizations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsProductDetails)) {
            return false;
        }
        AwsProductDetails other = (AwsProductDetails)obj;
        return Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.serviceCode(), other.serviceCode()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && Objects.equals(this.amount(), other.amount()) && Objects.equals(this.optimizedAmount(), other.optimizedAmount()) && Objects.equals(this.potentialSavingsAmount(), other.potentialSavingsAmount()) && this.hasOptimizations() == other.hasOptimizations() && Objects.equals(this.optimizations(), other.optimizations());
    }

    public final String toString() {
        return ToString.builder((String)"AwsProductDetails").add("ProductCode", (Object)this.productCode()).add("ServiceCode", (Object)this.serviceCode()).add("Categories", this.hasCategories() ? this.categories() : null).add("Amount", (Object)(this.amount() == null ? null : "*** Sensitive Data Redacted ***")).add("OptimizedAmount", (Object)(this.optimizedAmount() == null ? null : "*** Sensitive Data Redacted ***")).add("PotentialSavingsAmount", (Object)(this.potentialSavingsAmount() == null ? null : "*** Sensitive Data Redacted ***")).add("Optimizations", this.hasOptimizations() ? this.optimizations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "OptimizedAmount": {
                return Optional.ofNullable(clazz.cast(this.optimizedAmount()));
            }
            case "PotentialSavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.potentialSavingsAmount()));
            }
            case "Optimizations": {
                return Optional.ofNullable(clazz.cast(this.optimizations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("Amount", AMOUNT_FIELD);
        map.put("OptimizedAmount", OPTIMIZED_AMOUNT_FIELD);
        map.put("PotentialSavingsAmount", POTENTIAL_SAVINGS_AMOUNT_FIELD);
        map.put("Optimizations", OPTIMIZATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsProductDetails, T> g) {
        return obj -> g.apply((AwsProductDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productCode;
        private String serviceCode;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private String amount;
        private String optimizedAmount;
        private String potentialSavingsAmount;
        private List<AwsProductOptimization> optimizations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsProductDetails model) {
            this.productCode(model.productCode);
            this.serviceCode(model.serviceCode);
            this.categories(model.categories);
            this.amount(model.amount);
            this.optimizedAmount(model.optimizedAmount);
            this.potentialSavingsAmount(model.potentialSavingsAmount);
            this.optimizations(model.optimizations);
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = AwsProductDetailsCategoriesListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = AwsProductDetailsCategoriesListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final String getAmount() {
            return this.amount;
        }

        public final void setAmount(String amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public final String getOptimizedAmount() {
            return this.optimizedAmount;
        }

        public final void setOptimizedAmount(String optimizedAmount) {
            this.optimizedAmount = optimizedAmount;
        }

        @Override
        public final Builder optimizedAmount(String optimizedAmount) {
            this.optimizedAmount = optimizedAmount;
            return this;
        }

        public final String getPotentialSavingsAmount() {
            return this.potentialSavingsAmount;
        }

        public final void setPotentialSavingsAmount(String potentialSavingsAmount) {
            this.potentialSavingsAmount = potentialSavingsAmount;
        }

        @Override
        public final Builder potentialSavingsAmount(String potentialSavingsAmount) {
            this.potentialSavingsAmount = potentialSavingsAmount;
            return this;
        }

        public final List<AwsProductOptimization.Builder> getOptimizations() {
            List<AwsProductOptimization.Builder> result = AwsProductOptimizationsListCopier.copyToBuilder(this.optimizations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizations(Collection<AwsProductOptimization.BuilderImpl> optimizations) {
            this.optimizations = AwsProductOptimizationsListCopier.copyFromBuilder(optimizations);
        }

        @Override
        public final Builder optimizations(Collection<AwsProductOptimization> optimizations) {
            this.optimizations = AwsProductOptimizationsListCopier.copy(optimizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizations(AwsProductOptimization ... optimizations) {
            this.optimizations(Arrays.asList(optimizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizations(Consumer<AwsProductOptimization.Builder> ... optimizations) {
            this.optimizations(Stream.of(optimizations).map(c -> (AwsProductOptimization)((AwsProductOptimization.Builder)AwsProductOptimization.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsProductDetails build() {
            return new AwsProductDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsProductDetails> {
        public Builder productCode(String var1);

        public Builder serviceCode(String var1);

        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder amount(String var1);

        public Builder optimizedAmount(String var1);

        public Builder potentialSavingsAmount(String var1);

        public Builder optimizations(Collection<AwsProductOptimization> var1);

        public Builder optimizations(AwsProductOptimization ... var1);

        public Builder optimizations(Consumer<AwsProductOptimization.Builder> ... var1);
    }
}

