/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSnapshotSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSnapshotSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ResourceSnapshotSummary.getter(ResourceSnapshotSummary::arn)).setter(ResourceSnapshotSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Integer> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Revision").getter(ResourceSnapshotSummary.getter(ResourceSnapshotSummary::revision)).setter(ResourceSnapshotSummary.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceSnapshotSummary.getter(ResourceSnapshotSummary::resourceTypeAsString)).setter(ResourceSnapshotSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResourceSnapshotSummary.getter(ResourceSnapshotSummary::resourceId)).setter(ResourceSnapshotSummary.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotTemplateName").getter(ResourceSnapshotSummary.getter(ResourceSnapshotSummary::resourceSnapshotTemplateName)).setter(ResourceSnapshotSummary.setter(Builder::resourceSnapshotTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateName").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(ResourceSnapshotSummary.getter(ResourceSnapshotSummary::createdBy)).setter(ResourceSnapshotSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, REVISION_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD, CREATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceSnapshotSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Integer revision;
    private final String resourceType;
    private final String resourceId;
    private final String resourceSnapshotTemplateName;
    private final String createdBy;

    private ResourceSnapshotSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.revision = builder.revision;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceSnapshotTemplateName = builder.resourceSnapshotTemplateName;
        this.createdBy = builder.createdBy;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer revision() {
        return this.revision;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceSnapshotTemplateName() {
        return this.resourceSnapshotTemplateName;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSnapshotSummary)) {
            return false;
        }
        ResourceSnapshotSummary other = (ResourceSnapshotSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceSnapshotTemplateName(), other.resourceSnapshotTemplateName()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSnapshotSummary").add("Arn", (Object)this.arn()).add("Revision", (Object)this.revision()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceSnapshotTemplateName", (Object)this.resourceSnapshotTemplateName()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceSnapshotTemplateName": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotTemplateName()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceSnapshotTemplateName", RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSnapshotSummary, T> g) {
        return obj -> g.apply((ResourceSnapshotSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Integer revision;
        private String resourceType;
        private String resourceId;
        private String resourceSnapshotTemplateName;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSnapshotSummary model) {
            this.arn(model.arn);
            this.revision(model.revision);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceSnapshotTemplateName(model.resourceSnapshotTemplateName);
            this.createdBy(model.createdBy);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceSnapshotTemplateName() {
            return this.resourceSnapshotTemplateName;
        }

        public final void setResourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
        }

        @Override
        public final Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public ResourceSnapshotSummary build() {
            return new ResourceSnapshotSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSnapshotSummary> {
        public Builder arn(String var1);

        public Builder revision(Integer var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceSnapshotTemplateName(String var1);

        public Builder createdBy(String var1);
    }
}

