/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotPayload;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSnapshotResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, GetResourceSnapshotResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::arn)).setter(GetResourceSnapshotResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::catalog)).setter(GetResourceSnapshotResponse.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::createdAt)).setter(GetResourceSnapshotResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::createdBy)).setter(GetResourceSnapshotResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementId").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::engagementId)).setter(GetResourceSnapshotResponse.setter(Builder::engagementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()}).build();
    private static final SdkField<ResourceSnapshotPayload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Payload").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::payload)).setter(GetResourceSnapshotResponse.setter(Builder::payload)).constructor(ResourceSnapshotPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::resourceId)).setter(GetResourceSnapshotResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSnapshotTemplateName").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::resourceSnapshotTemplateName)).setter(GetResourceSnapshotResponse.setter(Builder::resourceSnapshotTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::resourceTypeAsString)).setter(GetResourceSnapshotResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Integer> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Revision").getter(GetResourceSnapshotResponse.getter(GetResourceSnapshotResponse::revision)).setter(GetResourceSnapshotResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, ENGAGEMENT_ID_FIELD, PAYLOAD_FIELD, RESOURCE_ID_FIELD, RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD, RESOURCE_TYPE_FIELD, REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceSnapshotResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String catalog;
    private final Instant createdAt;
    private final String createdBy;
    private final String engagementId;
    private final ResourceSnapshotPayload payload;
    private final String resourceId;
    private final String resourceSnapshotTemplateName;
    private final String resourceType;
    private final Integer revision;

    private GetResourceSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.engagementId = builder.engagementId;
        this.payload = builder.payload;
        this.resourceId = builder.resourceId;
        this.resourceSnapshotTemplateName = builder.resourceSnapshotTemplateName;
        this.resourceType = builder.resourceType;
        this.revision = builder.revision;
    }

    public final String arn() {
        return this.arn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String engagementId() {
        return this.engagementId;
    }

    public final ResourceSnapshotPayload payload() {
        return this.payload;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceSnapshotTemplateName() {
        return this.resourceSnapshotTemplateName;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Integer revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSnapshotTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSnapshotResponse)) {
            return false;
        }
        GetResourceSnapshotResponse other = (GetResourceSnapshotResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.engagementId(), other.engagementId()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceSnapshotTemplateName(), other.resourceSnapshotTemplateName()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceSnapshotResponse").add("Arn", (Object)this.arn()).add("Catalog", (Object)this.catalog()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).add("EngagementId", (Object)this.engagementId()).add("Payload", (Object)this.payload()).add("ResourceId", (Object)this.resourceId()).add("ResourceSnapshotTemplateName", (Object)this.resourceSnapshotTemplateName()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "EngagementId": {
                return Optional.ofNullable(clazz.cast(this.engagementId()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceSnapshotTemplateName": {
                return Optional.ofNullable(clazz.cast(this.resourceSnapshotTemplateName()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceSnapshotTemplateName", RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSnapshotResponse, T> g) {
        return obj -> g.apply((GetResourceSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String catalog;
        private Instant createdAt;
        private String createdBy;
        private String engagementId;
        private ResourceSnapshotPayload payload;
        private String resourceId;
        private String resourceSnapshotTemplateName;
        private String resourceType;
        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSnapshotResponse model) {
            super(model);
            this.arn(model.arn);
            this.catalog(model.catalog);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.engagementId(model.engagementId);
            this.payload(model.payload);
            this.resourceId(model.resourceId);
            this.resourceSnapshotTemplateName(model.resourceSnapshotTemplateName);
            this.resourceType(model.resourceType);
            this.revision(model.revision);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getEngagementId() {
            return this.engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final ResourceSnapshotPayload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        public final void setPayload(ResourceSnapshotPayload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(ResourceSnapshotPayload payload) {
            this.payload = payload;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceSnapshotTemplateName() {
            return this.resourceSnapshotTemplateName;
        }

        public final void setResourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
        }

        @Override
        public final Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public GetResourceSnapshotResponse build() {
            return new GetResourceSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSnapshotResponse> {
        public Builder arn(String var1);

        public Builder catalog(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder engagementId(String var1);

        public Builder payload(ResourceSnapshotPayload var1);

        default public Builder payload(Consumer<ResourceSnapshotPayload.Builder> payload) {
            return this.payload((ResourceSnapshotPayload)((ResourceSnapshotPayload.Builder)ResourceSnapshotPayload.builder().applyMutation(payload)).build());
        }

        public Builder resourceId(String var1);

        public Builder resourceSnapshotTemplateName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder revision(Integer var1);
    }
}

