/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.CountryCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressSummary> {
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(AddressSummary.getter(AddressSummary::city)).setter(AddressSummary.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(AddressSummary.getter(AddressSummary::countryCodeAsString)).setter(AddressSummary.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(AddressSummary.getter(AddressSummary::postalCode)).setter(AddressSummary.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateOrRegion").getter(AddressSummary.getter(AddressSummary::stateOrRegion)).setter(AddressSummary.setter(Builder::stateOrRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_CODE_FIELD, POSTAL_CODE_FIELD, STATE_OR_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddressSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String city;
    private final String countryCode;
    private final String postalCode;
    private final String stateOrRegion;

    private AddressSummary(BuilderImpl builder) {
        this.city = builder.city;
        this.countryCode = builder.countryCode;
        this.postalCode = builder.postalCode;
        this.stateOrRegion = builder.stateOrRegion;
    }

    public final String city() {
        return this.city;
    }

    public final CountryCode countryCode() {
        return CountryCode.fromValue(this.countryCode);
    }

    public final String countryCodeAsString() {
        return this.countryCode;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String stateOrRegion() {
        return this.stateOrRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateOrRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressSummary)) {
            return false;
        }
        AddressSummary other = (AddressSummary)obj;
        return Objects.equals(this.city(), other.city()) && Objects.equals(this.countryCodeAsString(), other.countryCodeAsString()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.stateOrRegion(), other.stateOrRegion());
    }

    public final String toString() {
        return ToString.builder((String)"AddressSummary").add("City", (Object)(this.city() == null ? null : "*** Sensitive Data Redacted ***")).add("CountryCode", (Object)(this.countryCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).add("StateOrRegion", (Object)(this.stateOrRegion() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCodeAsString()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "StateOrRegion": {
                return Optional.ofNullable(clazz.cast(this.stateOrRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("City", CITY_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("StateOrRegion", STATE_OR_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressSummary, T> g) {
        return obj -> g.apply((AddressSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String city;
        private String countryCode;
        private String postalCode;
        private String stateOrRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressSummary model) {
            this.city(model.city);
            this.countryCode(model.countryCode);
            this.postalCode(model.postalCode);
            this.stateOrRegion(model.stateOrRegion);
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrRegion() {
            return this.stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public AddressSummary build() {
            return new AddressSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressSummary> {
        public Builder city(String var1);

        public Builder countryCode(String var1);

        public Builder countryCode(CountryCode var1);

        public Builder postalCode(String var1);

        public Builder stateOrRegion(String var1);
    }
}

