/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementInvitationSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse;

public class ListEngagementInvitationsPublisher
implements SdkPublisher<ListEngagementInvitationsResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListEngagementInvitationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEngagementInvitationsPublisher(PartnerCentralSellingAsyncClient client, ListEngagementInvitationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEngagementInvitationsPublisher(PartnerCentralSellingAsyncClient client, ListEngagementInvitationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEngagementInvitationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEngagementInvitationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EngagementInvitationSummary> engagementInvitationSummaries() {
        Function<ListEngagementInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementInvitationSummaries() != null) {
                return response.engagementInvitationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEngagementInvitationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEngagementInvitationsResponseFetcher
    implements AsyncPageFetcher<ListEngagementInvitationsResponse> {
        private ListEngagementInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEngagementInvitationsResponse> nextPage(ListEngagementInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementInvitationsPublisher.this.client.listEngagementInvitations(ListEngagementInvitationsPublisher.this.firstRequest);
            }
            return ListEngagementInvitationsPublisher.this.client.listEngagementInvitations((ListEngagementInvitationsRequest)((Object)ListEngagementInvitationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

