/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.AddressSummary;
import software.amazon.awssdk.services.partnercentralselling.model.Industry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSummary> {
    private static final SdkField<AddressSummary> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(AccountSummary.getter(AccountSummary::address)).setter(AccountSummary.setter(Builder::address)).constructor(AddressSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(AccountSummary.getter(AccountSummary::companyName)).setter(AccountSummary.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(AccountSummary.getter(AccountSummary::industryAsString)).setter(AccountSummary.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<String> OTHER_INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherIndustry").getter(AccountSummary.getter(AccountSummary::otherIndustry)).setter(AccountSummary.setter(Builder::otherIndustry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherIndustry").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteUrl").getter(AccountSummary.getter(AccountSummary::websiteUrl)).setter(AccountSummary.setter(Builder::websiteUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, COMPANY_NAME_FIELD, INDUSTRY_FIELD, OTHER_INDUSTRY_FIELD, WEBSITE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AddressSummary address;
    private final String companyName;
    private final String industry;
    private final String otherIndustry;
    private final String websiteUrl;

    private AccountSummary(BuilderImpl builder) {
        this.address = builder.address;
        this.companyName = builder.companyName;
        this.industry = builder.industry;
        this.otherIndustry = builder.otherIndustry;
        this.websiteUrl = builder.websiteUrl;
    }

    public final AddressSummary address() {
        return this.address;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final Industry industry() {
        return Industry.fromValue(this.industry);
    }

    public final String industryAsString() {
        return this.industry;
    }

    public final String otherIndustry() {
        return this.otherIndustry;
    }

    public final String websiteUrl() {
        return this.websiteUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherIndustry());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSummary)) {
            return false;
        }
        AccountSummary other = (AccountSummary)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.industryAsString(), other.industryAsString()) && Objects.equals(this.otherIndustry(), other.otherIndustry()) && Objects.equals(this.websiteUrl(), other.websiteUrl());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSummary").add("Address", (Object)this.address()).add("CompanyName", (Object)(this.companyName() == null ? null : "*** Sensitive Data Redacted ***")).add("Industry", (Object)this.industryAsString()).add("OtherIndustry", (Object)this.otherIndustry()).add("WebsiteUrl", (Object)(this.websiteUrl() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industryAsString()));
            }
            case "OtherIndustry": {
                return Optional.ofNullable(clazz.cast(this.otherIndustry()));
            }
            case "WebsiteUrl": {
                return Optional.ofNullable(clazz.cast(this.websiteUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Address", ADDRESS_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("Industry", INDUSTRY_FIELD);
        map.put("OtherIndustry", OTHER_INDUSTRY_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSummary, T> g) {
        return obj -> g.apply((AccountSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AddressSummary address;
        private String companyName;
        private String industry;
        private String otherIndustry;
        private String websiteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSummary model) {
            this.address(model.address);
            this.companyName(model.companyName);
            this.industry(model.industry);
            this.otherIndustry(model.otherIndustry);
            this.websiteUrl(model.websiteUrl);
        }

        public final AddressSummary.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(AddressSummary.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressSummary address) {
            this.address = address;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getIndustry() {
            return this.industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getOtherIndustry() {
            return this.otherIndustry;
        }

        public final void setOtherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
        }

        @Override
        public final Builder otherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
            return this;
        }

        public final String getWebsiteUrl() {
            return this.websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public AccountSummary build() {
            return new AccountSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSummary> {
        public Builder address(AddressSummary var1);

        default public Builder address(Consumer<AddressSummary.Builder> address) {
            return this.address((AddressSummary)((AddressSummary.Builder)AddressSummary.builder().applyMutation(address)).build());
        }

        public Builder companyName(String var1);

        public Builder industry(String var1);

        public Builder industry(Industry var1);

        public Builder otherIndustry(String var1);

        public Builder websiteUrl(String var1);
    }
}

