/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary;

public class ListResourceSnapshotsIterable
implements SdkIterable<ListResourceSnapshotsResponse> {
    private final PartnerCentralSellingClient client;
    private final ListResourceSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceSnapshotsIterable(PartnerCentralSellingClient client, ListResourceSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceSnapshotsResponseFetcher();
    }

    public Iterator<ListResourceSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceSnapshotSummary> resourceSnapshotSummaries() {
        Function<ListResourceSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceSnapshotSummaries() != null) {
                return response.resourceSnapshotSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceSnapshotsResponseFetcher
    implements SyncPageFetcher<ListResourceSnapshotsResponse> {
        private ListResourceSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceSnapshotsResponse nextPage(ListResourceSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSnapshotsIterable.this.client.listResourceSnapshots(ListResourceSnapshotsIterable.this.firstRequest);
            }
            return ListResourceSnapshotsIterable.this.client.listResourceSnapshots((ListResourceSnapshotsRequest)((Object)ListResourceSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

