/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementResourceAssociationSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse;

public class ListEngagementResourceAssociationsIterable
implements SdkIterable<ListEngagementResourceAssociationsResponse> {
    private final PartnerCentralSellingClient client;
    private final ListEngagementResourceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngagementResourceAssociationsIterable(PartnerCentralSellingClient client, ListEngagementResourceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEngagementResourceAssociationsResponseFetcher();
    }

    public Iterator<ListEngagementResourceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries() {
        Function<ListEngagementResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementResourceAssociationSummaries() != null) {
                return response.engagementResourceAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEngagementResourceAssociationsResponseFetcher
    implements SyncPageFetcher<ListEngagementResourceAssociationsResponse> {
        private ListEngagementResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngagementResourceAssociationsResponse nextPage(ListEngagementResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementResourceAssociationsIterable.this.client.listEngagementResourceAssociations(ListEngagementResourceAssociationsIterable.this.firstRequest);
            }
            return ListEngagementResourceAssociationsIterable.this.client.listEngagementResourceAssociations((ListEngagementResourceAssociationsRequest)((Object)ListEngagementResourceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

