/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequestCategoryListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequestIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequestStatusListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionSort;
import software.amazon.awssdk.services.partnercentralselling.model.SolutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolutionsRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListSolutionsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListSolutionsRequest.getter(ListSolutionsRequest::catalog)).setter(ListSolutionsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Category").getter(ListSolutionsRequest.getter(ListSolutionsRequest::category)).setter(ListSolutionsRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identifier").getter(ListSolutionsRequest.getter(ListSolutionsRequest::identifier)).setter(ListSolutionsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListSolutionsRequest.getter(ListSolutionsRequest::maxResults)).setter(ListSolutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSolutionsRequest.getter(ListSolutionsRequest::nextToken)).setter(ListSolutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<SolutionSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListSolutionsRequest.getter(ListSolutionsRequest::sort)).setter(ListSolutionsRequest.setter(Builder::sort)).constructor(SolutionSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(ListSolutionsRequest.getter(ListSolutionsRequest::statusAsStrings)).setter(ListSolutionsRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CATEGORY_FIELD, IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSolutionsRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> category;
    private final List<String> identifier;
    private final Integer maxResults;
    private final String nextToken;
    private final SolutionSort sort;
    private final List<String> status;

    private ListSolutionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.category = builder.category;
        this.identifier = builder.identifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
        this.status = builder.status;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasCategory() {
        return this.category != null && !(this.category instanceof SdkAutoConstructList);
    }

    public final List<String> category() {
        return this.category;
    }

    public final boolean hasIdentifier() {
        return this.identifier != null && !(this.identifier instanceof SdkAutoConstructList);
    }

    public final List<String> identifier() {
        return this.identifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SolutionSort sort() {
        return this.sort;
    }

    public final List<SolutionStatus> status() {
        return ListSolutionsRequestStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategory() ? this.category() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifier() ? this.identifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionsRequest)) {
            return false;
        }
        ListSolutionsRequest other = (ListSolutionsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasCategory() == other.hasCategory() && Objects.equals(this.category(), other.category()) && this.hasIdentifier() == other.hasIdentifier() && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sort(), other.sort()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolutionsRequest").add("Catalog", (Object)this.catalog()).add("Category", this.hasCategory() ? this.category() : null).add("Identifier", this.hasIdentifier() ? this.identifier() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Sort", (Object)this.sort()).add("Status", this.hasStatus() ? this.statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionsRequest, T> g) {
        return obj -> g.apply((ListSolutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> category = DefaultSdkAutoConstructList.getInstance();
        private List<String> identifier = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private SolutionSort sort;
        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.category(model.category);
            this.identifier(model.identifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sort(model.sort);
            this.statusWithStrings(model.status);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCategory() {
            if (this.category instanceof SdkAutoConstructList) {
                return null;
            }
            return this.category;
        }

        public final void setCategory(Collection<String> category) {
            this.category = ListSolutionsRequestCategoryListCopier.copy(category);
        }

        @Override
        public final Builder category(Collection<String> category) {
            this.category = ListSolutionsRequestCategoryListCopier.copy(category);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(String ... category) {
            this.category(Arrays.asList(category));
            return this;
        }

        public final Collection<String> getIdentifier() {
            if (this.identifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identifier;
        }

        public final void setIdentifier(Collection<String> identifier) {
            this.identifier = ListSolutionsRequestIdentifierListCopier.copy(identifier);
        }

        @Override
        public final Builder identifier(Collection<String> identifier) {
            this.identifier = ListSolutionsRequestIdentifierListCopier.copy(identifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifier(String ... identifier) {
            this.identifier(Arrays.asList(identifier));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SolutionSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(SolutionSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SolutionSort sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ListSolutionsRequestStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ListSolutionsRequestStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<SolutionStatus> status) {
            this.status = ListSolutionsRequestStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(SolutionStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSolutionsRequest build() {
            return new ListSolutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolutionsRequest> {
        public Builder catalog(String var1);

        public Builder category(Collection<String> var1);

        public Builder category(String ... var1);

        public Builder identifier(Collection<String> var1);

        public Builder identifier(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sort(SolutionSort var1);

        default public Builder sort(Consumer<SolutionSort.Builder> sort) {
            return this.sort((SolutionSort)((SolutionSort.Builder)SolutionSort.builder().applyMutation(sort)).build());
        }

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<SolutionStatus> var1);

        public Builder status(SolutionStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

