/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MarketingSource {
    MARKETING_ACTIVITY("Marketing Activity"),
    NONE("None"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MarketingSource> VALUE_MAP;
    private final String value;

    private MarketingSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MarketingSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MarketingSource> knownValues() {
        EnumSet<MarketingSource> knownValues = EnumSet.allOf(MarketingSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MarketingSource.class, MarketingSource::toString);
    }
}

