/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementCustomer;
import software.amazon.awssdk.services.partnercentralselling.model.ProjectDetails;
import software.amazon.awssdk.services.partnercentralselling.model.ReceiverResponsibility;
import software.amazon.awssdk.services.partnercentralselling.model.ReceiverResponsibilityListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.SenderContact;
import software.amazon.awssdk.services.partnercentralselling.model.SenderContactListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpportunityInvitationPayload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpportunityInvitationPayload> {
    private static final SdkField<EngagementCustomer> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(OpportunityInvitationPayload.getter(OpportunityInvitationPayload::customer)).setter(OpportunityInvitationPayload.setter(Builder::customer)).constructor(EngagementCustomer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<ProjectDetails> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Project").getter(OpportunityInvitationPayload.getter(OpportunityInvitationPayload::project)).setter(OpportunityInvitationPayload.setter(Builder::project)).constructor(ProjectDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()}).build();
    private static final SdkField<List<String>> RECEIVER_RESPONSIBILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReceiverResponsibilities").getter(OpportunityInvitationPayload.getter(OpportunityInvitationPayload::receiverResponsibilitiesAsStrings)).setter(OpportunityInvitationPayload.setter(Builder::receiverResponsibilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverResponsibilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SenderContact>> SENDER_CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SenderContacts").getter(OpportunityInvitationPayload.getter(OpportunityInvitationPayload::senderContacts)).setter(OpportunityInvitationPayload.setter(Builder::senderContacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderContacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SenderContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_FIELD, PROJECT_FIELD, RECEIVER_RESPONSIBILITIES_FIELD, SENDER_CONTACTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpportunityInvitationPayload.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EngagementCustomer customer;
    private final ProjectDetails project;
    private final List<String> receiverResponsibilities;
    private final List<SenderContact> senderContacts;

    private OpportunityInvitationPayload(BuilderImpl builder) {
        this.customer = builder.customer;
        this.project = builder.project;
        this.receiverResponsibilities = builder.receiverResponsibilities;
        this.senderContacts = builder.senderContacts;
    }

    public final EngagementCustomer customer() {
        return this.customer;
    }

    public final ProjectDetails project() {
        return this.project;
    }

    public final List<ReceiverResponsibility> receiverResponsibilities() {
        return ReceiverResponsibilityListCopier.copyStringToEnum(this.receiverResponsibilities);
    }

    public final boolean hasReceiverResponsibilities() {
        return this.receiverResponsibilities != null && !(this.receiverResponsibilities instanceof SdkAutoConstructList);
    }

    public final List<String> receiverResponsibilitiesAsStrings() {
        return this.receiverResponsibilities;
    }

    public final boolean hasSenderContacts() {
        return this.senderContacts != null && !(this.senderContacts instanceof SdkAutoConstructList);
    }

    public final List<SenderContact> senderContacts() {
        return this.senderContacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReceiverResponsibilities() ? this.receiverResponsibilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSenderContacts() ? this.senderContacts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunityInvitationPayload)) {
            return false;
        }
        OpportunityInvitationPayload other = (OpportunityInvitationPayload)obj;
        return Objects.equals(this.customer(), other.customer()) && Objects.equals(this.project(), other.project()) && this.hasReceiverResponsibilities() == other.hasReceiverResponsibilities() && Objects.equals(this.receiverResponsibilitiesAsStrings(), other.receiverResponsibilitiesAsStrings()) && this.hasSenderContacts() == other.hasSenderContacts() && Objects.equals(this.senderContacts(), other.senderContacts());
    }

    public final String toString() {
        return ToString.builder((String)"OpportunityInvitationPayload").add("Customer", (Object)this.customer()).add("Project", (Object)this.project()).add("ReceiverResponsibilities", this.hasReceiverResponsibilities() ? this.receiverResponsibilitiesAsStrings() : null).add("SenderContacts", this.hasSenderContacts() ? this.senderContacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "ReceiverResponsibilities": {
                return Optional.ofNullable(clazz.cast(this.receiverResponsibilitiesAsStrings()));
            }
            case "SenderContacts": {
                return Optional.ofNullable(clazz.cast(this.senderContacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("ReceiverResponsibilities", RECEIVER_RESPONSIBILITIES_FIELD);
        map.put("SenderContacts", SENDER_CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpportunityInvitationPayload, T> g) {
        return obj -> g.apply((OpportunityInvitationPayload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EngagementCustomer customer;
        private ProjectDetails project;
        private List<String> receiverResponsibilities = DefaultSdkAutoConstructList.getInstance();
        private List<SenderContact> senderContacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunityInvitationPayload model) {
            this.customer(model.customer);
            this.project(model.project);
            this.receiverResponsibilitiesWithStrings(model.receiverResponsibilities);
            this.senderContacts(model.senderContacts);
        }

        public final EngagementCustomer.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(EngagementCustomer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(EngagementCustomer customer) {
            this.customer = customer;
            return this;
        }

        public final ProjectDetails.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(ProjectDetails.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectDetails project) {
            this.project = project;
            return this;
        }

        public final Collection<String> getReceiverResponsibilities() {
            if (this.receiverResponsibilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.receiverResponsibilities;
        }

        public final void setReceiverResponsibilities(Collection<String> receiverResponsibilities) {
            this.receiverResponsibilities = ReceiverResponsibilityListCopier.copy(receiverResponsibilities);
        }

        @Override
        public final Builder receiverResponsibilitiesWithStrings(Collection<String> receiverResponsibilities) {
            this.receiverResponsibilities = ReceiverResponsibilityListCopier.copy(receiverResponsibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverResponsibilitiesWithStrings(String ... receiverResponsibilities) {
            this.receiverResponsibilitiesWithStrings(Arrays.asList(receiverResponsibilities));
            return this;
        }

        @Override
        public final Builder receiverResponsibilities(Collection<ReceiverResponsibility> receiverResponsibilities) {
            this.receiverResponsibilities = ReceiverResponsibilityListCopier.copyEnumToString(receiverResponsibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverResponsibilities(ReceiverResponsibility ... receiverResponsibilities) {
            this.receiverResponsibilities(Arrays.asList(receiverResponsibilities));
            return this;
        }

        public final List<SenderContact.Builder> getSenderContacts() {
            List<SenderContact.Builder> result = SenderContactListCopier.copyToBuilder(this.senderContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSenderContacts(Collection<SenderContact.BuilderImpl> senderContacts) {
            this.senderContacts = SenderContactListCopier.copyFromBuilder(senderContacts);
        }

        @Override
        public final Builder senderContacts(Collection<SenderContact> senderContacts) {
            this.senderContacts = SenderContactListCopier.copy(senderContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderContacts(SenderContact ... senderContacts) {
            this.senderContacts(Arrays.asList(senderContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderContacts(Consumer<SenderContact.Builder> ... senderContacts) {
            this.senderContacts(Stream.of(senderContacts).map(c -> (SenderContact)((SenderContact.Builder)SenderContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OpportunityInvitationPayload build() {
            return new OpportunityInvitationPayload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpportunityInvitationPayload> {
        public Builder customer(EngagementCustomer var1);

        default public Builder customer(Consumer<EngagementCustomer.Builder> customer) {
            return this.customer((EngagementCustomer)((EngagementCustomer.Builder)EngagementCustomer.builder().applyMutation(customer)).build());
        }

        public Builder project(ProjectDetails var1);

        default public Builder project(Consumer<ProjectDetails.Builder> project) {
            return this.project((ProjectDetails)((ProjectDetails.Builder)ProjectDetails.builder().applyMutation(project)).build());
        }

        public Builder receiverResponsibilitiesWithStrings(Collection<String> var1);

        public Builder receiverResponsibilitiesWithStrings(String ... var1);

        public Builder receiverResponsibilities(Collection<ReceiverResponsibility> var1);

        public Builder receiverResponsibilities(ReceiverResponsibility ... var1);

        public Builder senderContacts(Collection<SenderContact> var1);

        public Builder senderContacts(SenderContact ... var1);

        public Builder senderContacts(Consumer<SenderContact.Builder> ... var1);
    }
}

