/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.RelatedEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateOpportunityRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, DisassociateOpportunityRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(DisassociateOpportunityRequest.getter(DisassociateOpportunityRequest::catalog)).setter(DisassociateOpportunityRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> OPPORTUNITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpportunityIdentifier").getter(DisassociateOpportunityRequest.getter(DisassociateOpportunityRequest::opportunityIdentifier)).setter(DisassociateOpportunityRequest.setter(Builder::opportunityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityIdentifier").build()}).build();
    private static final SdkField<String> RELATED_ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedEntityIdentifier").getter(DisassociateOpportunityRequest.getter(DisassociateOpportunityRequest::relatedEntityIdentifier)).setter(DisassociateOpportunityRequest.setter(Builder::relatedEntityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifier").build()}).build();
    private static final SdkField<String> RELATED_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedEntityType").getter(DisassociateOpportunityRequest.getter(DisassociateOpportunityRequest::relatedEntityTypeAsString)).setter(DisassociateOpportunityRequest.setter(Builder::relatedEntityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, OPPORTUNITY_IDENTIFIER_FIELD, RELATED_ENTITY_IDENTIFIER_FIELD, RELATED_ENTITY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateOpportunityRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String opportunityIdentifier;
    private final String relatedEntityIdentifier;
    private final String relatedEntityType;

    private DisassociateOpportunityRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.opportunityIdentifier = builder.opportunityIdentifier;
        this.relatedEntityIdentifier = builder.relatedEntityIdentifier;
        this.relatedEntityType = builder.relatedEntityType;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String opportunityIdentifier() {
        return this.opportunityIdentifier;
    }

    public final String relatedEntityIdentifier() {
        return this.relatedEntityIdentifier;
    }

    public final RelatedEntityType relatedEntityType() {
        return RelatedEntityType.fromValue(this.relatedEntityType);
    }

    public final String relatedEntityTypeAsString() {
        return this.relatedEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.opportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedEntityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedEntityTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateOpportunityRequest)) {
            return false;
        }
        DisassociateOpportunityRequest other = (DisassociateOpportunityRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.opportunityIdentifier(), other.opportunityIdentifier()) && Objects.equals(this.relatedEntityIdentifier(), other.relatedEntityIdentifier()) && Objects.equals(this.relatedEntityTypeAsString(), other.relatedEntityTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateOpportunityRequest").add("Catalog", (Object)this.catalog()).add("OpportunityIdentifier", (Object)this.opportunityIdentifier()).add("RelatedEntityIdentifier", (Object)this.relatedEntityIdentifier()).add("RelatedEntityType", (Object)this.relatedEntityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "OpportunityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.opportunityIdentifier()));
            }
            case "RelatedEntityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.relatedEntityIdentifier()));
            }
            case "RelatedEntityType": {
                return Optional.ofNullable(clazz.cast(this.relatedEntityTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("OpportunityIdentifier", OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("RelatedEntityIdentifier", RELATED_ENTITY_IDENTIFIER_FIELD);
        map.put("RelatedEntityType", RELATED_ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateOpportunityRequest, T> g) {
        return obj -> g.apply((DisassociateOpportunityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String opportunityIdentifier;
        private String relatedEntityIdentifier;
        private String relatedEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateOpportunityRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.opportunityIdentifier(model.opportunityIdentifier);
            this.relatedEntityIdentifier(model.relatedEntityIdentifier);
            this.relatedEntityType(model.relatedEntityType);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getOpportunityIdentifier() {
            return this.opportunityIdentifier;
        }

        public final void setOpportunityIdentifier(String opportunityIdentifier) {
            this.opportunityIdentifier = opportunityIdentifier;
        }

        @Override
        public final Builder opportunityIdentifier(String opportunityIdentifier) {
            this.opportunityIdentifier = opportunityIdentifier;
            return this;
        }

        public final String getRelatedEntityIdentifier() {
            return this.relatedEntityIdentifier;
        }

        public final void setRelatedEntityIdentifier(String relatedEntityIdentifier) {
            this.relatedEntityIdentifier = relatedEntityIdentifier;
        }

        @Override
        public final Builder relatedEntityIdentifier(String relatedEntityIdentifier) {
            this.relatedEntityIdentifier = relatedEntityIdentifier;
            return this;
        }

        public final String getRelatedEntityType() {
            return this.relatedEntityType;
        }

        public final void setRelatedEntityType(String relatedEntityType) {
            this.relatedEntityType = relatedEntityType;
        }

        @Override
        public final Builder relatedEntityType(String relatedEntityType) {
            this.relatedEntityType = relatedEntityType;
            return this;
        }

        @Override
        public final Builder relatedEntityType(RelatedEntityType relatedEntityType) {
            this.relatedEntityType(relatedEntityType == null ? null : relatedEntityType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateOpportunityRequest build() {
            return new DisassociateOpportunityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateOpportunityRequest> {
        public Builder catalog(String var1);

        public Builder opportunityIdentifier(String var1);

        public Builder relatedEntityIdentifier(String var1);

        public Builder relatedEntityType(String var1);

        public Builder relatedEntityType(RelatedEntityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

