/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RevenueModel {
    CONTRACT("Contract"),
    PAY_AS_YOU_GO("Pay-as-you-go"),
    SUBSCRIPTION("Subscription"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RevenueModel> VALUE_MAP;
    private final String value;

    private RevenueModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevenueModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevenueModel> knownValues() {
        EnumSet<RevenueModel> knownValues = EnumSet.allOf(RevenueModel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RevenueModel.class, RevenueModel::toString);
    }
}

