/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsAccountIdOrAliasListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementIdentifiersCopier;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementInvitationPayloadType;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementInvitationsPayloadTypeCopier;
import software.amazon.awssdk.services.partnercentralselling.model.InvitationStatus;
import software.amazon.awssdk.services.partnercentralselling.model.InvitationStatusListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunityEngagementInvitationSort;
import software.amazon.awssdk.services.partnercentralselling.model.ParticipantType;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementInvitationsRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListEngagementInvitationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::catalog)).setter(ListEngagementInvitationsRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngagementIdentifier").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::engagementIdentifier)).setter(ListEngagementInvitationsRequest.setter(Builder::engagementIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::maxResults)).setter(ListEngagementInvitationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::nextToken)).setter(ListEngagementInvitationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantType").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::participantTypeAsString)).setter(ListEngagementInvitationsRequest.setter(Builder::participantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()}).build();
    private static final SdkField<List<String>> PAYLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PayloadType").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::payloadTypeAsStrings)).setter(ListEngagementInvitationsRequest.setter(Builder::payloadTypeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SENDER_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SenderAwsAccountId").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::senderAwsAccountId)).setter(ListEngagementInvitationsRequest.setter(Builder::senderAwsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderAwsAccountId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OpportunityEngagementInvitationSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::sort)).setter(ListEngagementInvitationsRequest.setter(Builder::sort)).constructor(OpportunityEngagementInvitationSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(ListEngagementInvitationsRequest.getter(ListEngagementInvitationsRequest::statusAsStrings)).setter(ListEngagementInvitationsRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ENGAGEMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PARTICIPANT_TYPE_FIELD, PAYLOAD_TYPE_FIELD, SENDER_AWS_ACCOUNT_ID_FIELD, SORT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Catalog", CATALOG_FIELD);
            this.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
            this.put("PayloadType", PAYLOAD_TYPE_FIELD);
            this.put("SenderAwsAccountId", SENDER_AWS_ACCOUNT_ID_FIELD);
            this.put("Sort", SORT_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final String catalog;
    private final List<String> engagementIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final String participantType;
    private final List<String> payloadType;
    private final List<String> senderAwsAccountId;
    private final OpportunityEngagementInvitationSort sort;
    private final List<String> status;

    private ListEngagementInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.participantType = builder.participantType;
        this.payloadType = builder.payloadType;
        this.senderAwsAccountId = builder.senderAwsAccountId;
        this.sort = builder.sort;
        this.status = builder.status;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasEngagementIdentifier() {
        return this.engagementIdentifier != null && !(this.engagementIdentifier instanceof SdkAutoConstructList);
    }

    public final List<String> engagementIdentifier() {
        return this.engagementIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ParticipantType participantType() {
        return ParticipantType.fromValue(this.participantType);
    }

    public final String participantTypeAsString() {
        return this.participantType;
    }

    public final List<EngagementInvitationPayloadType> payloadType() {
        return EngagementInvitationsPayloadTypeCopier.copyStringToEnum(this.payloadType);
    }

    public final boolean hasPayloadType() {
        return this.payloadType != null && !(this.payloadType instanceof SdkAutoConstructList);
    }

    public final List<String> payloadTypeAsStrings() {
        return this.payloadType;
    }

    public final boolean hasSenderAwsAccountId() {
        return this.senderAwsAccountId != null && !(this.senderAwsAccountId instanceof SdkAutoConstructList);
    }

    public final List<String> senderAwsAccountId() {
        return this.senderAwsAccountId;
    }

    public final OpportunityEngagementInvitationSort sort() {
        return this.sort;
    }

    public final List<InvitationStatus> status() {
        return InvitationStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagementIdentifier() ? this.engagementIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayloadType() ? this.payloadTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSenderAwsAccountId() ? this.senderAwsAccountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementInvitationsRequest)) {
            return false;
        }
        ListEngagementInvitationsRequest other = (ListEngagementInvitationsRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasEngagementIdentifier() == other.hasEngagementIdentifier() && Objects.equals(this.engagementIdentifier(), other.engagementIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.participantTypeAsString(), other.participantTypeAsString()) && this.hasPayloadType() == other.hasPayloadType() && Objects.equals(this.payloadTypeAsStrings(), other.payloadTypeAsStrings()) && this.hasSenderAwsAccountId() == other.hasSenderAwsAccountId() && Objects.equals(this.senderAwsAccountId(), other.senderAwsAccountId()) && Objects.equals(this.sort(), other.sort()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementInvitationsRequest").add("Catalog", (Object)this.catalog()).add("EngagementIdentifier", this.hasEngagementIdentifier() ? this.engagementIdentifier() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ParticipantType", (Object)this.participantTypeAsString()).add("PayloadType", this.hasPayloadType() ? this.payloadTypeAsStrings() : null).add("SenderAwsAccountId", (Object)(this.senderAwsAccountId() == null ? null : "*** Sensitive Data Redacted ***")).add("Sort", (Object)this.sort()).add("Status", this.hasStatus() ? this.statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "EngagementIdentifier": {
                return Optional.ofNullable(clazz.cast(this.engagementIdentifier()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ParticipantType": {
                return Optional.ofNullable(clazz.cast(this.participantTypeAsString()));
            }
            case "PayloadType": {
                return Optional.ofNullable(clazz.cast(this.payloadTypeAsStrings()));
            }
            case "SenderAwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.senderAwsAccountId()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementInvitationsRequest, T> g) {
        return obj -> g.apply((ListEngagementInvitationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private String participantType;
        private List<String> payloadType = DefaultSdkAutoConstructList.getInstance();
        private List<String> senderAwsAccountId = DefaultSdkAutoConstructList.getInstance();
        private OpportunityEngagementInvitationSort sort;
        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementInvitationsRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.engagementIdentifier(model.engagementIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.participantType(model.participantType);
            this.payloadTypeWithStrings(model.payloadType);
            this.senderAwsAccountId(model.senderAwsAccountId);
            this.sort(model.sort);
            this.statusWithStrings(model.status);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (this.engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String ... engagementIdentifier) {
            this.engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getParticipantType() {
            return this.participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final Collection<String> getPayloadType() {
            if (this.payloadType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.payloadType;
        }

        public final void setPayloadType(Collection<String> payloadType) {
            this.payloadType = EngagementInvitationsPayloadTypeCopier.copy(payloadType);
        }

        @Override
        public final Builder payloadTypeWithStrings(Collection<String> payloadType) {
            this.payloadType = EngagementInvitationsPayloadTypeCopier.copy(payloadType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloadTypeWithStrings(String ... payloadType) {
            this.payloadTypeWithStrings(Arrays.asList(payloadType));
            return this;
        }

        @Override
        public final Builder payloadType(Collection<EngagementInvitationPayloadType> payloadType) {
            this.payloadType = EngagementInvitationsPayloadTypeCopier.copyEnumToString(payloadType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloadType(EngagementInvitationPayloadType ... payloadType) {
            this.payloadType(Arrays.asList(payloadType));
            return this;
        }

        public final Collection<String> getSenderAwsAccountId() {
            if (this.senderAwsAccountId instanceof SdkAutoConstructList) {
                return null;
            }
            return this.senderAwsAccountId;
        }

        public final void setSenderAwsAccountId(Collection<String> senderAwsAccountId) {
            this.senderAwsAccountId = AwsAccountIdOrAliasListCopier.copy(senderAwsAccountId);
        }

        @Override
        public final Builder senderAwsAccountId(Collection<String> senderAwsAccountId) {
            this.senderAwsAccountId = AwsAccountIdOrAliasListCopier.copy(senderAwsAccountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderAwsAccountId(String ... senderAwsAccountId) {
            this.senderAwsAccountId(Arrays.asList(senderAwsAccountId));
            return this;
        }

        public final OpportunityEngagementInvitationSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(OpportunityEngagementInvitationSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(OpportunityEngagementInvitationSort sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = InvitationStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = InvitationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<InvitationStatus> status) {
            this.status = InvitationStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(InvitationStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementInvitationsRequest build() {
            return new ListEngagementInvitationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementInvitationsRequest> {
        public Builder catalog(String var1);

        public Builder engagementIdentifier(Collection<String> var1);

        public Builder engagementIdentifier(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder participantType(String var1);

        public Builder participantType(ParticipantType var1);

        public Builder payloadTypeWithStrings(Collection<String> var1);

        public Builder payloadTypeWithStrings(String ... var1);

        public Builder payloadType(Collection<EngagementInvitationPayloadType> var1);

        public Builder payloadType(EngagementInvitationPayloadType ... var1);

        public Builder senderAwsAccountId(Collection<String> var1);

        public Builder senderAwsAccountId(String ... var1);

        public Builder sort(OpportunityEngagementInvitationSort var1);

        default public Builder sort(Consumer<OpportunityEngagementInvitationSort.Builder> sort) {
            return this.sort((OpportunityEngagementInvitationSort)((OpportunityEngagementInvitationSort.Builder)OpportunityEngagementInvitationSort.builder().applyMutation(sort)).build());
        }

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<InvitationStatus> var1);

        public Builder status(InvitationStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

