/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingAsyncClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary;

public class ListResourceSnapshotsPublisher
implements SdkPublisher<ListResourceSnapshotsResponse> {
    private final PartnerCentralSellingAsyncClient client;
    private final ListResourceSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceSnapshotsPublisher(PartnerCentralSellingAsyncClient client, ListResourceSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceSnapshotsPublisher(PartnerCentralSellingAsyncClient client, ListResourceSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceSnapshotSummary> resourceSnapshotSummaries() {
        Function<ListResourceSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceSnapshotSummaries() != null) {
                return response.resourceSnapshotSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceSnapshotsResponseFetcher
    implements AsyncPageFetcher<ListResourceSnapshotsResponse> {
        private ListResourceSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceSnapshotsResponse> nextPage(ListResourceSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSnapshotsPublisher.this.client.listResourceSnapshots(ListResourceSnapshotsPublisher.this.firstRequest);
            }
            return ListResourceSnapshotsPublisher.this.client.listResourceSnapshots((ListResourceSnapshotsRequest)((Object)ListResourceSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

