/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementSummary;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementSummaryListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementsResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, ListEngagementsResponse> {
    private static final SdkField<List<EngagementSummary>> ENGAGEMENT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngagementSummaryList").getter(ListEngagementsResponse.getter(ListEngagementsResponse::engagementSummaryList)).setter(ListEngagementsResponse.setter(Builder::engagementSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngagementSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementsResponse.getter(ListEngagementsResponse::nextToken)).setter(ListEngagementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EngagementSummaryList", ENGAGEMENT_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<EngagementSummary> engagementSummaryList;
    private final String nextToken;

    private ListEngagementsResponse(BuilderImpl builder) {
        super(builder);
        this.engagementSummaryList = builder.engagementSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEngagementSummaryList() {
        return this.engagementSummaryList != null && !(this.engagementSummaryList instanceof SdkAutoConstructList);
    }

    public final List<EngagementSummary> engagementSummaryList() {
        return this.engagementSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagementSummaryList() ? this.engagementSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsResponse)) {
            return false;
        }
        ListEngagementsResponse other = (ListEngagementsResponse)((Object)obj);
        return this.hasEngagementSummaryList() == other.hasEngagementSummaryList() && Objects.equals(this.engagementSummaryList(), other.engagementSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementsResponse").add("EngagementSummaryList", this.hasEngagementSummaryList() ? this.engagementSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngagementSummaryList": {
                return Optional.ofNullable(clazz.cast(this.engagementSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsResponse, T> g) {
        return obj -> g.apply((ListEngagementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private List<EngagementSummary> engagementSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsResponse model) {
            super(model);
            this.engagementSummaryList(model.engagementSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<EngagementSummary.Builder> getEngagementSummaryList() {
            List<EngagementSummary.Builder> result = EngagementSummaryListCopier.copyToBuilder(this.engagementSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngagementSummaryList(Collection<EngagementSummary.BuilderImpl> engagementSummaryList) {
            this.engagementSummaryList = EngagementSummaryListCopier.copyFromBuilder(engagementSummaryList);
        }

        @Override
        public final Builder engagementSummaryList(Collection<EngagementSummary> engagementSummaryList) {
            this.engagementSummaryList = EngagementSummaryListCopier.copy(engagementSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementSummaryList(EngagementSummary ... engagementSummaryList) {
            this.engagementSummaryList(Arrays.asList(engagementSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementSummaryList(Consumer<EngagementSummary.Builder> ... engagementSummaryList) {
            this.engagementSummaryList(Stream.of(engagementSummaryList).map(c -> (EngagementSummary)((EngagementSummary.Builder)EngagementSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEngagementsResponse build() {
            return new ListEngagementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementsResponse> {
        public Builder engagementSummaryList(Collection<EngagementSummary> var1);

        public Builder engagementSummaryList(EngagementSummary ... var1);

        public Builder engagementSummaryList(Consumer<EngagementSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

