/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralchannel.model.ServicePeriodType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeServicePeriodHandshakeDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RevokeServicePeriodHandshakeDetail> {
    private static final SdkField<String> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("note").getter(RevokeServicePeriodHandshakeDetail.getter(RevokeServicePeriodHandshakeDetail::note)).setter(RevokeServicePeriodHandshakeDetail.setter(Builder::note)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("note").build()}).build();
    private static final SdkField<String> SERVICE_PERIOD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("servicePeriodType").getter(RevokeServicePeriodHandshakeDetail.getter(RevokeServicePeriodHandshakeDetail::servicePeriodTypeAsString)).setter(RevokeServicePeriodHandshakeDetail.setter(Builder::servicePeriodType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePeriodType").build()}).build();
    private static final SdkField<String> MINIMUM_NOTICE_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("minimumNoticeDays").getter(RevokeServicePeriodHandshakeDetail.getter(RevokeServicePeriodHandshakeDetail::minimumNoticeDays)).setter(RevokeServicePeriodHandshakeDetail.setter(Builder::minimumNoticeDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumNoticeDays").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(RevokeServicePeriodHandshakeDetail.getter(RevokeServicePeriodHandshakeDetail::startDate)).setter(RevokeServicePeriodHandshakeDetail.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDate").getter(RevokeServicePeriodHandshakeDetail.getter(RevokeServicePeriodHandshakeDetail::endDate)).setter(RevokeServicePeriodHandshakeDetail.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTE_FIELD, SERVICE_PERIOD_TYPE_FIELD, MINIMUM_NOTICE_DAYS_FIELD, START_DATE_FIELD, END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokeServicePeriodHandshakeDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String note;
    private final String servicePeriodType;
    private final String minimumNoticeDays;
    private final Instant startDate;
    private final Instant endDate;

    private RevokeServicePeriodHandshakeDetail(BuilderImpl builder) {
        this.note = builder.note;
        this.servicePeriodType = builder.servicePeriodType;
        this.minimumNoticeDays = builder.minimumNoticeDays;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    public final String note() {
        return this.note;
    }

    public final ServicePeriodType servicePeriodType() {
        return ServicePeriodType.fromValue(this.servicePeriodType);
    }

    public final String servicePeriodTypeAsString() {
        return this.servicePeriodType;
    }

    public final String minimumNoticeDays() {
        return this.minimumNoticeDays;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePeriodTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNoticeDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeServicePeriodHandshakeDetail)) {
            return false;
        }
        RevokeServicePeriodHandshakeDetail other = (RevokeServicePeriodHandshakeDetail)obj;
        return Objects.equals(this.note(), other.note()) && Objects.equals(this.servicePeriodTypeAsString(), other.servicePeriodTypeAsString()) && Objects.equals(this.minimumNoticeDays(), other.minimumNoticeDays()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeServicePeriodHandshakeDetail").add("Note", (Object)this.note()).add("ServicePeriodType", (Object)this.servicePeriodTypeAsString()).add("MinimumNoticeDays", (Object)this.minimumNoticeDays()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "servicePeriodType": {
                return Optional.ofNullable(clazz.cast(this.servicePeriodTypeAsString()));
            }
            case "minimumNoticeDays": {
                return Optional.ofNullable(clazz.cast(this.minimumNoticeDays()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("note", NOTE_FIELD);
        map.put("servicePeriodType", SERVICE_PERIOD_TYPE_FIELD);
        map.put("minimumNoticeDays", MINIMUM_NOTICE_DAYS_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("endDate", END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeServicePeriodHandshakeDetail, T> g) {
        return obj -> g.apply((RevokeServicePeriodHandshakeDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String note;
        private String servicePeriodType;
        private String minimumNoticeDays;
        private Instant startDate;
        private Instant endDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeServicePeriodHandshakeDetail model) {
            this.note(model.note);
            this.servicePeriodType(model.servicePeriodType);
            this.minimumNoticeDays(model.minimumNoticeDays);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
        }

        public final String getNote() {
            return this.note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        @Override
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        public final String getServicePeriodType() {
            return this.servicePeriodType;
        }

        public final void setServicePeriodType(String servicePeriodType) {
            this.servicePeriodType = servicePeriodType;
        }

        @Override
        public final Builder servicePeriodType(String servicePeriodType) {
            this.servicePeriodType = servicePeriodType;
            return this;
        }

        @Override
        public final Builder servicePeriodType(ServicePeriodType servicePeriodType) {
            this.servicePeriodType(servicePeriodType == null ? null : servicePeriodType.toString());
            return this;
        }

        public final String getMinimumNoticeDays() {
            return this.minimumNoticeDays;
        }

        public final void setMinimumNoticeDays(String minimumNoticeDays) {
            this.minimumNoticeDays = minimumNoticeDays;
        }

        @Override
        public final Builder minimumNoticeDays(String minimumNoticeDays) {
            this.minimumNoticeDays = minimumNoticeDays;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public RevokeServicePeriodHandshakeDetail build() {
            return new RevokeServicePeriodHandshakeDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RevokeServicePeriodHandshakeDetail> {
        public Builder note(String var1);

        public Builder servicePeriodType(String var1);

        public Builder servicePeriodType(ServicePeriodType var1);

        public Builder minimumNoticeDays(String var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);
    }
}

