/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerCentralChannelRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationshipRequest
extends PartnerCentralChannelRequest
implements ToCopyableBuilder<Builder, GetRelationshipRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalog").getter(GetRelationshipRequest.getter(GetRelationshipRequest::catalog)).setter(GetRelationshipRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()}).build();
    private static final SdkField<String> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("programManagementAccountIdentifier").getter(GetRelationshipRequest.getter(GetRelationshipRequest::programManagementAccountIdentifier)).setter(GetRelationshipRequest.setter(Builder::programManagementAccountIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(GetRelationshipRequest.getter(GetRelationshipRequest::identifier)).setter(GetRelationshipRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD, IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRelationshipRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String programManagementAccountIdentifier;
    private final String identifier;

    private GetRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.programManagementAccountIdentifier = builder.programManagementAccountIdentifier;
        this.identifier = builder.identifier;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String programManagementAccountIdentifier() {
        return this.programManagementAccountIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.programManagementAccountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationshipRequest)) {
            return false;
        }
        GetRelationshipRequest other = (GetRelationshipRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.programManagementAccountIdentifier(), other.programManagementAccountIdentifier()) && Objects.equals(this.identifier(), other.identifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationshipRequest").add("Catalog", (Object)this.catalog()).add("ProgramManagementAccountIdentifier", (Object)this.programManagementAccountIdentifier()).add("Identifier", (Object)this.identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "programManagementAccountIdentifier": {
                return Optional.ofNullable(clazz.cast(this.programManagementAccountIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("catalog", CATALOG_FIELD);
        map.put("programManagementAccountIdentifier", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationshipRequest, T> g) {
        return obj -> g.apply((GetRelationshipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralChannelRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String programManagementAccountIdentifier;
        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationshipRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.programManagementAccountIdentifier(model.programManagementAccountIdentifier);
            this.identifier(model.identifier);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProgramManagementAccountIdentifier() {
            return this.programManagementAccountIdentifier;
        }

        public final void setProgramManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
        }

        @Override
        public final Builder programManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationshipRequest build() {
            return new GetRelationshipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralChannelRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationshipRequest> {
        public Builder catalog(String var1);

        public Builder programManagementAccountIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

