/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationshipRequest extends PartnerCentralChannelRequest implements
        ToCopyableBuilder<GetRelationshipRequest.Builder, GetRelationshipRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(GetRelationshipRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("programManagementAccountIdentifier")
            .getter(getter(GetRelationshipRequest::programManagementAccountIdentifier))
            .setter(setter(Builder::programManagementAccountIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountIdentifier")
                    .build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(GetRelationshipRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD, IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String programManagementAccountIdentifier;

    private final String identifier;

    private GetRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.programManagementAccountIdentifier = builder.programManagementAccountIdentifier;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * The catalog identifier for the relationship.
     * </p>
     * 
     * @return The catalog identifier for the relationship.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The identifier of the program management account associated with the relationship.
     * </p>
     * 
     * @return The identifier of the program management account associated with the relationship.
     */
    public final String programManagementAccountIdentifier() {
        return programManagementAccountIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the relationship to retrieve.
     * </p>
     * 
     * @return The unique identifier of the relationship to retrieve.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationshipRequest)) {
            return false;
        }
        GetRelationshipRequest other = (GetRelationshipRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(programManagementAccountIdentifier(), other.programManagementAccountIdentifier())
                && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationshipRequest").add("Catalog", catalog())
                .add("ProgramManagementAccountIdentifier", programManagementAccountIdentifier()).add("Identifier", identifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "programManagementAccountIdentifier":
            return Optional.ofNullable(clazz.cast(programManagementAccountIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalog", CATALOG_FIELD);
        map.put("programManagementAccountIdentifier", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationshipRequest, T> g) {
        return obj -> g.apply((GetRelationshipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationshipRequest> {
        /**
         * <p>
         * The catalog identifier for the relationship.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier for the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The identifier of the program management account associated with the relationship.
         * </p>
         * 
         * @param programManagementAccountIdentifier
         *        The identifier of the program management account associated with the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountIdentifier(String programManagementAccountIdentifier);

        /**
         * <p>
         * The unique identifier of the relationship to retrieve.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the relationship to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralChannelRequest.BuilderImpl implements Builder {
        private String catalog;

        private String programManagementAccountIdentifier;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationshipRequest model) {
            super(model);
            catalog(model.catalog);
            programManagementAccountIdentifier(model.programManagementAccountIdentifier);
            identifier(model.identifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getProgramManagementAccountIdentifier() {
            return programManagementAccountIdentifier;
        }

        public final void setProgramManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
        }

        @Override
        public final Builder programManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationshipRequest build() {
            return new GetRelationshipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
