/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRelationshipRequest extends PartnerCentralChannelRequest implements
        ToCopyableBuilder<CreateRelationshipRequest.Builder, CreateRelationshipRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("catalog")
            .getter(getter(CreateRelationshipRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalog").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationType").getter(getter(CreateRelationshipRequest::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<String> PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("programManagementAccountIdentifier")
            .getter(getter(CreateRelationshipRequest::programManagementAccountIdentifier))
            .setter(setter(Builder::programManagementAccountIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programManagementAccountIdentifier")
                    .build()).build();

    private static final SdkField<String> ASSOCIATED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedAccountId").getter(getter(CreateRelationshipRequest::associatedAccountId))
            .setter(setter(Builder::associatedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccountId").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateRelationshipRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> RESALE_ACCOUNT_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resaleAccountModel").getter(getter(CreateRelationshipRequest::resaleAccountModelAsString))
            .setter(setter(Builder::resaleAccountModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resaleAccountModel").build())
            .build();

    private static final SdkField<String> SECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sector")
            .getter(getter(CreateRelationshipRequest::sectorAsString)).setter(setter(Builder::sector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateRelationshipRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRelationshipRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SupportPlan> REQUESTED_SUPPORT_PLAN_FIELD = SdkField
            .<SupportPlan> builder(MarshallingType.SDK_POJO).memberName("requestedSupportPlan")
            .getter(getter(CreateRelationshipRequest::requestedSupportPlan)).setter(setter(Builder::requestedSupportPlan))
            .constructor(SupportPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedSupportPlan").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            ASSOCIATION_TYPE_FIELD, PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD, ASSOCIATED_ACCOUNT_ID_FIELD, DISPLAY_NAME_FIELD,
            RESALE_ACCOUNT_MODEL_FIELD, SECTOR_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, REQUESTED_SUPPORT_PLAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String associationType;

    private final String programManagementAccountIdentifier;

    private final String associatedAccountId;

    private final String displayName;

    private final String resaleAccountModel;

    private final String sector;

    private final String clientToken;

    private final List<Tag> tags;

    private final SupportPlan requestedSupportPlan;

    private CreateRelationshipRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.associationType = builder.associationType;
        this.programManagementAccountIdentifier = builder.programManagementAccountIdentifier;
        this.associatedAccountId = builder.associatedAccountId;
        this.displayName = builder.displayName;
        this.resaleAccountModel = builder.resaleAccountModel;
        this.sector = builder.sector;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.requestedSupportPlan = builder.requestedSupportPlan;
    }

    /**
     * <p>
     * The catalog identifier for the relationship.
     * </p>
     * 
     * @return The catalog identifier for the relationship.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The type of association for the relationship (e.g., reseller, distributor).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association for the relationship (e.g., reseller, distributor).
     * @see AssociationType
     */
    public final AssociationType associationType() {
        return AssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of association for the relationship (e.g., reseller, distributor).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of association for the relationship (e.g., reseller, distributor).
     * @see AssociationType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The identifier of the program management account for this relationship.
     * </p>
     * 
     * @return The identifier of the program management account for this relationship.
     */
    public final String programManagementAccountIdentifier() {
        return programManagementAccountIdentifier;
    }

    /**
     * <p>
     * The AWS account ID to associate in this relationship.
     * </p>
     * 
     * @return The AWS account ID to associate in this relationship.
     */
    public final String associatedAccountId() {
        return associatedAccountId;
    }

    /**
     * <p>
     * A human-readable name for the relationship.
     * </p>
     * 
     * @return A human-readable name for the relationship.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The resale account model for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resaleAccountModel} will return {@link ResaleAccountModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resaleAccountModelAsString}.
     * </p>
     * 
     * @return The resale account model for the relationship.
     * @see ResaleAccountModel
     */
    public final ResaleAccountModel resaleAccountModel() {
        return ResaleAccountModel.fromValue(resaleAccountModel);
    }

    /**
     * <p>
     * The resale account model for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resaleAccountModel} will return {@link ResaleAccountModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resaleAccountModelAsString}.
     * </p>
     * 
     * @return The resale account model for the relationship.
     * @see ResaleAccountModel
     */
    public final String resaleAccountModelAsString() {
        return resaleAccountModel;
    }

    /**
     * <p>
     * The business sector for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The business sector for the relationship.
     * @see Sector
     */
    public final Sector sector() {
        return Sector.fromValue(sector);
    }

    /**
     * <p>
     * The business sector for the relationship.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The business sector for the relationship.
     * @see Sector
     */
    public final String sectorAsString() {
        return sector;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs to associate with the relationship.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs to associate with the relationship.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The support plan requested for this relationship.
     * </p>
     * 
     * @return The support plan requested for this relationship.
     */
    public final SupportPlan requestedSupportPlan() {
        return requestedSupportPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programManagementAccountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(associatedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(resaleAccountModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestedSupportPlan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationshipRequest)) {
            return false;
        }
        CreateRelationshipRequest other = (CreateRelationshipRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(programManagementAccountIdentifier(), other.programManagementAccountIdentifier())
                && Objects.equals(associatedAccountId(), other.associatedAccountId())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(resaleAccountModelAsString(), other.resaleAccountModelAsString())
                && Objects.equals(sectorAsString(), other.sectorAsString()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(requestedSupportPlan(), other.requestedSupportPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRelationshipRequest").add("Catalog", catalog())
                .add("AssociationType", associationTypeAsString())
                .add("ProgramManagementAccountIdentifier", programManagementAccountIdentifier())
                .add("AssociatedAccountId", associatedAccountId()).add("DisplayName", displayName())
                .add("ResaleAccountModel", resaleAccountModelAsString()).add("Sector", sectorAsString())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null)
                .add("RequestedSupportPlan", requestedSupportPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "programManagementAccountIdentifier":
            return Optional.ofNullable(clazz.cast(programManagementAccountIdentifier()));
        case "associatedAccountId":
            return Optional.ofNullable(clazz.cast(associatedAccountId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "resaleAccountModel":
            return Optional.ofNullable(clazz.cast(resaleAccountModelAsString()));
        case "sector":
            return Optional.ofNullable(clazz.cast(sectorAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "requestedSupportPlan":
            return Optional.ofNullable(clazz.cast(requestedSupportPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalog", CATALOG_FIELD);
        map.put("associationType", ASSOCIATION_TYPE_FIELD);
        map.put("programManagementAccountIdentifier", PROGRAM_MANAGEMENT_ACCOUNT_IDENTIFIER_FIELD);
        map.put("associatedAccountId", ASSOCIATED_ACCOUNT_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("resaleAccountModel", RESALE_ACCOUNT_MODEL_FIELD);
        map.put("sector", SECTOR_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("requestedSupportPlan", REQUESTED_SUPPORT_PLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationshipRequest, T> g) {
        return obj -> g.apply((CreateRelationshipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralChannelRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRelationshipRequest> {
        /**
         * <p>
         * The catalog identifier for the relationship.
         * </p>
         * 
         * @param catalog
         *        The catalog identifier for the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The type of association for the relationship (e.g., reseller, distributor).
         * </p>
         * 
         * @param associationType
         *        The type of association for the relationship (e.g., reseller, distributor).
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of association for the relationship (e.g., reseller, distributor).
         * </p>
         * 
         * @param associationType
         *        The type of association for the relationship (e.g., reseller, distributor).
         * @see AssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationType
         */
        Builder associationType(AssociationType associationType);

        /**
         * <p>
         * The identifier of the program management account for this relationship.
         * </p>
         * 
         * @param programManagementAccountIdentifier
         *        The identifier of the program management account for this relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programManagementAccountIdentifier(String programManagementAccountIdentifier);

        /**
         * <p>
         * The AWS account ID to associate in this relationship.
         * </p>
         * 
         * @param associatedAccountId
         *        The AWS account ID to associate in this relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccountId(String associatedAccountId);

        /**
         * <p>
         * A human-readable name for the relationship.
         * </p>
         * 
         * @param displayName
         *        A human-readable name for the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The resale account model for the relationship.
         * </p>
         * 
         * @param resaleAccountModel
         *        The resale account model for the relationship.
         * @see ResaleAccountModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResaleAccountModel
         */
        Builder resaleAccountModel(String resaleAccountModel);

        /**
         * <p>
         * The resale account model for the relationship.
         * </p>
         * 
         * @param resaleAccountModel
         *        The resale account model for the relationship.
         * @see ResaleAccountModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResaleAccountModel
         */
        Builder resaleAccountModel(ResaleAccountModel resaleAccountModel);

        /**
         * <p>
         * The business sector for the relationship.
         * </p>
         * 
         * @param sector
         *        The business sector for the relationship.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(String sector);

        /**
         * <p>
         * The business sector for the relationship.
         * </p>
         * 
         * @param sector
         *        The business sector for the relationship.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(Sector sector);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Key-value pairs to associate with the relationship.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs to associate with the relationship.
         * </p>
         * 
         * @param tags
         *        Key-value pairs to associate with the relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs to associate with the relationship.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralchannel.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The support plan requested for this relationship.
         * </p>
         * 
         * @param requestedSupportPlan
         *        The support plan requested for this relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedSupportPlan(SupportPlan requestedSupportPlan);

        /**
         * <p>
         * The support plan requested for this relationship.
         * </p>
         * This is a convenience method that creates an instance of the {@link SupportPlan.Builder} avoiding the need to
         * create one manually via {@link SupportPlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupportPlan.Builder#build()} is called immediately and its result
         * is passed to {@link #requestedSupportPlan(SupportPlan)}.
         * 
         * @param requestedSupportPlan
         *        a consumer that will call methods on {@link SupportPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedSupportPlan(SupportPlan)
         */
        default Builder requestedSupportPlan(Consumer<SupportPlan.Builder> requestedSupportPlan) {
            return requestedSupportPlan(SupportPlan.builder().applyMutation(requestedSupportPlan).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralChannelRequest.BuilderImpl implements Builder {
        private String catalog;

        private String associationType;

        private String programManagementAccountIdentifier;

        private String associatedAccountId;

        private String displayName;

        private String resaleAccountModel;

        private String sector;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private SupportPlan requestedSupportPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationshipRequest model) {
            super(model);
            catalog(model.catalog);
            associationType(model.associationType);
            programManagementAccountIdentifier(model.programManagementAccountIdentifier);
            associatedAccountId(model.associatedAccountId);
            displayName(model.displayName);
            resaleAccountModel(model.resaleAccountModel);
            sector(model.sector);
            clientToken(model.clientToken);
            tags(model.tags);
            requestedSupportPlan(model.requestedSupportPlan);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getAssociationType() {
            return associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getProgramManagementAccountIdentifier() {
            return programManagementAccountIdentifier;
        }

        public final void setProgramManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
        }

        @Override
        public final Builder programManagementAccountIdentifier(String programManagementAccountIdentifier) {
            this.programManagementAccountIdentifier = programManagementAccountIdentifier;
            return this;
        }

        public final String getAssociatedAccountId() {
            return associatedAccountId;
        }

        public final void setAssociatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
        }

        @Override
        public final Builder associatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getResaleAccountModel() {
            return resaleAccountModel;
        }

        public final void setResaleAccountModel(String resaleAccountModel) {
            this.resaleAccountModel = resaleAccountModel;
        }

        @Override
        public final Builder resaleAccountModel(String resaleAccountModel) {
            this.resaleAccountModel = resaleAccountModel;
            return this;
        }

        @Override
        public final Builder resaleAccountModel(ResaleAccountModel resaleAccountModel) {
            this.resaleAccountModel(resaleAccountModel == null ? null : resaleAccountModel.toString());
            return this;
        }

        public final String getSector() {
            return sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SupportPlan.Builder getRequestedSupportPlan() {
            return requestedSupportPlan != null ? requestedSupportPlan.toBuilder() : null;
        }

        public final void setRequestedSupportPlan(SupportPlan.BuilderImpl requestedSupportPlan) {
            this.requestedSupportPlan = requestedSupportPlan != null ? requestedSupportPlan.build() : null;
        }

        @Override
        public final Builder requestedSupportPlan(SupportPlan requestedSupportPlan) {
            this.requestedSupportPlan = requestedSupportPlan;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationshipRequest build() {
            return new CreateRelationshipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
