/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralchannel;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.partnercentralchannel.model.AcceptChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.AcceptChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.CancelChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CancelChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateProgramManagementAccountRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateProgramManagementAccountResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.CreateRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteProgramManagementAccountRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteProgramManagementAccountResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.DeleteRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.GetRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.GetRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.RejectChannelHandshakeRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.RejectChannelHandshakeResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateProgramManagementAccountRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateProgramManagementAccountResponse;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateRelationshipRequest;
import software.amazon.awssdk.services.partnercentralchannel.model.UpdateRelationshipResponse;
import software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesPublisher;
import software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsPublisher;
import software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsPublisher;

/**
 * Service client for accessing Partner Central Channel API asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS Partner Central Channel service for managing partner relationships, handshakes, and program management accounts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PartnerCentralChannelAsyncClient extends AwsClient {
    String SERVICE_NAME = "partnercentral-channel";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "partnercentral-channel";

    /**
     * <p>
     * Accepts a pending channel handshake request from another AWS account.
     * </p>
     *
     * @param acceptChannelHandshakeRequest
     * @return A Java Future containing the result of the AcceptChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.AcceptChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/AcceptChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptChannelHandshakeResponse> acceptChannelHandshake(
            AcceptChannelHandshakeRequest acceptChannelHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a pending channel handshake request from another AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link AcceptChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param acceptChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.AcceptChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AcceptChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.AcceptChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/AcceptChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptChannelHandshakeResponse> acceptChannelHandshake(
            Consumer<AcceptChannelHandshakeRequest.Builder> acceptChannelHandshakeRequest) {
        return acceptChannelHandshake(AcceptChannelHandshakeRequest.builder().applyMutation(acceptChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a pending channel handshake request.
     * </p>
     *
     * @param cancelChannelHandshakeRequest
     * @return A Java Future containing the result of the CancelChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CancelChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CancelChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelChannelHandshakeResponse> cancelChannelHandshake(
            CancelChannelHandshakeRequest cancelChannelHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending channel handshake request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link CancelChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param cancelChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CancelChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CancelChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CancelChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CancelChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelChannelHandshakeResponse> cancelChannelHandshake(
            Consumer<CancelChannelHandshakeRequest.Builder> cancelChannelHandshakeRequest) {
        return cancelChannelHandshake(CancelChannelHandshakeRequest.builder().applyMutation(cancelChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new channel handshake request to establish a partnership with another AWS account.
     * </p>
     *
     * @param createChannelHandshakeRequest
     * @return A Java Future containing the result of the CreateChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The request would exceed a service quota limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CreateChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChannelHandshakeResponse> createChannelHandshake(
            CreateChannelHandshakeRequest createChannelHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new channel handshake request to establish a partnership with another AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param createChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CreateChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The request would exceed a service quota limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CreateChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChannelHandshakeResponse> createChannelHandshake(
            Consumer<CreateChannelHandshakeRequest.Builder> createChannelHandshakeRequest) {
        return createChannelHandshake(CreateChannelHandshakeRequest.builder().applyMutation(createChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new program management account for managing partner relationships.
     * </p>
     *
     * @param createProgramManagementAccountRequest
     * @return A Java Future containing the result of the CreateProgramManagementAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The request would exceed a service quota limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CreateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProgramManagementAccountResponse> createProgramManagementAccount(
            CreateProgramManagementAccountRequest createProgramManagementAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new program management account for managing partner relationships.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProgramManagementAccountRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProgramManagementAccountRequest#builder()}
     * </p>
     *
     * @param createProgramManagementAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CreateProgramManagementAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateProgramManagementAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The request would exceed a service quota limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CreateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProgramManagementAccountResponse> createProgramManagementAccount(
            Consumer<CreateProgramManagementAccountRequest.Builder> createProgramManagementAccountRequest) {
        return createProgramManagementAccount(CreateProgramManagementAccountRequest.builder()
                .applyMutation(createProgramManagementAccountRequest).build());
    }

    /**
     * <p>
     * Creates a new partner relationship between accounts.
     * </p>
     *
     * @param createRelationshipRequest
     * @return A Java Future containing the result of the CreateRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The request would exceed a service quota limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CreateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRelationshipResponse> createRelationship(CreateRelationshipRequest createRelationshipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new partner relationship between accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelationshipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRelationshipRequest#builder()}
     * </p>
     *
     * @param createRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.CreateRelationshipRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>ServiceQuotaExceededException The request would exceed a service quota limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.CreateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/CreateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRelationshipResponse> createRelationship(
            Consumer<CreateRelationshipRequest.Builder> createRelationshipRequest) {
        return createRelationship(CreateRelationshipRequest.builder().applyMutation(createRelationshipRequest).build());
    }

    /**
     * <p>
     * Deletes a program management account.
     * </p>
     *
     * @param deleteProgramManagementAccountRequest
     * @return A Java Future containing the result of the DeleteProgramManagementAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.DeleteProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProgramManagementAccountResponse> deleteProgramManagementAccount(
            DeleteProgramManagementAccountRequest deleteProgramManagementAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a program management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProgramManagementAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProgramManagementAccountRequest#builder()}
     * </p>
     *
     * @param deleteProgramManagementAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.DeleteProgramManagementAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteProgramManagementAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.DeleteProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProgramManagementAccountResponse> deleteProgramManagementAccount(
            Consumer<DeleteProgramManagementAccountRequest.Builder> deleteProgramManagementAccountRequest) {
        return deleteProgramManagementAccount(DeleteProgramManagementAccountRequest.builder()
                .applyMutation(deleteProgramManagementAccountRequest).build());
    }

    /**
     * <p>
     * Deletes a partner relationship.
     * </p>
     *
     * @param deleteRelationshipRequest
     * @return A Java Future containing the result of the DeleteRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.DeleteRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRelationshipResponse> deleteRelationship(DeleteRelationshipRequest deleteRelationshipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a partner relationship.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRelationshipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRelationshipRequest#builder()}
     * </p>
     *
     * @param deleteRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.DeleteRelationshipRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.DeleteRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/DeleteRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRelationshipResponse> deleteRelationship(
            Consumer<DeleteRelationshipRequest.Builder> deleteRelationshipRequest) {
        return deleteRelationship(DeleteRelationshipRequest.builder().applyMutation(deleteRelationshipRequest).build());
    }

    /**
     * <p>
     * Retrieves details of a specific partner relationship.
     * </p>
     *
     * @param getRelationshipRequest
     * @return A Java Future containing the result of the GetRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.GetRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/GetRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRelationshipResponse> getRelationship(GetRelationshipRequest getRelationshipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of a specific partner relationship.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelationshipRequest.Builder} avoiding the need
     * to create one manually via {@link GetRelationshipRequest#builder()}
     * </p>
     *
     * @param getRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.GetRelationshipRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.GetRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/GetRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRelationshipResponse> getRelationship(
            Consumer<GetRelationshipRequest.Builder> getRelationshipRequest) {
        return getRelationship(GetRelationshipRequest.builder().applyMutation(getRelationshipRequest).build());
    }

    /**
     * <p>
     * Lists channel handshakes based on specified criteria.
     * </p>
     *
     * @param listChannelHandshakesRequest
     * @return A Java Future containing the result of the ListChannelHandshakes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChannelHandshakesResponse> listChannelHandshakes(
            ListChannelHandshakesRequest listChannelHandshakesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists channel handshakes based on specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelHandshakesRequest.Builder} avoiding the
     * need to create one manually via {@link ListChannelHandshakesRequest#builder()}
     * </p>
     *
     * @param listChannelHandshakesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListChannelHandshakes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChannelHandshakesResponse> listChannelHandshakes(
            Consumer<ListChannelHandshakesRequest.Builder> listChannelHandshakesRequest) {
        return listChannelHandshakes(ListChannelHandshakesRequest.builder().applyMutation(listChannelHandshakesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesPublisher publisher = client.listChannelHandshakesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesPublisher publisher = client.listChannelHandshakesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChannelHandshakesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelHandshakesPublisher listChannelHandshakesPaginator(
            ListChannelHandshakesRequest listChannelHandshakesRequest) {
        return new ListChannelHandshakesPublisher(this, listChannelHandshakesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesPublisher publisher = client.listChannelHandshakesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListChannelHandshakesPublisher publisher = client.listChannelHandshakesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannelHandshakes(software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelHandshakesRequest.Builder} avoiding the
     * need to create one manually via {@link ListChannelHandshakesRequest#builder()}
     * </p>
     *
     * @param listChannelHandshakesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListChannelHandshakesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListChannelHandshakes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListChannelHandshakes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChannelHandshakesPublisher listChannelHandshakesPaginator(
            Consumer<ListChannelHandshakesRequest.Builder> listChannelHandshakesRequest) {
        return listChannelHandshakesPaginator(ListChannelHandshakesRequest.builder().applyMutation(listChannelHandshakesRequest)
                .build());
    }

    /**
     * <p>
     * Lists program management accounts based on specified criteria.
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     * @return A Java Future containing the result of the ListProgramManagementAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProgramManagementAccountsResponse> listProgramManagementAccounts(
            ListProgramManagementAccountsRequest listProgramManagementAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists program management accounts based on specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProgramManagementAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProgramManagementAccountsRequest#builder()}
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListProgramManagementAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProgramManagementAccountsResponse> listProgramManagementAccounts(
            Consumer<ListProgramManagementAccountsRequest.Builder> listProgramManagementAccountsRequest) {
        return listProgramManagementAccounts(ListProgramManagementAccountsRequest.builder()
                .applyMutation(listProgramManagementAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsPublisher publisher = client.listProgramManagementAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsPublisher publisher = client.listProgramManagementAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgramManagementAccountsPublisher listProgramManagementAccountsPaginator(
            ListProgramManagementAccountsRequest listProgramManagementAccountsRequest) {
        return new ListProgramManagementAccountsPublisher(this, listProgramManagementAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsPublisher publisher = client.listProgramManagementAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListProgramManagementAccountsPublisher publisher = client.listProgramManagementAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProgramManagementAccounts(software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProgramManagementAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProgramManagementAccountsRequest#builder()}
     * </p>
     *
     * @param listProgramManagementAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListProgramManagementAccountsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListProgramManagementAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListProgramManagementAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgramManagementAccountsPublisher listProgramManagementAccountsPaginator(
            Consumer<ListProgramManagementAccountsRequest.Builder> listProgramManagementAccountsRequest) {
        return listProgramManagementAccountsPaginator(ListProgramManagementAccountsRequest.builder()
                .applyMutation(listProgramManagementAccountsRequest).build());
    }

    /**
     * <p>
     * Lists partner relationships based on specified criteria.
     * </p>
     *
     * @param listRelationshipsRequest
     * @return A Java Future containing the result of the ListRelationships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRelationshipsResponse> listRelationships(ListRelationshipsRequest listRelationshipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists partner relationships based on specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelationshipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRelationshipsRequest#builder()}
     * </p>
     *
     * @param listRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRelationships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRelationshipsResponse> listRelationships(
            Consumer<ListRelationshipsRequest.Builder> listRelationshipsRequest) {
        return listRelationships(ListRelationshipsRequest.builder().applyMutation(listRelationshipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsPublisher publisher = client.listRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsPublisher publisher = client.listRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRelationshipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelationshipsPublisher listRelationshipsPaginator(ListRelationshipsRequest listRelationshipsRequest) {
        return new ListRelationshipsPublisher(this, listRelationshipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsPublisher publisher = client.listRelationshipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralchannel.paginators.ListRelationshipsPublisher publisher = client.listRelationshipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelationships(software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelationshipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRelationshipsRequest#builder()}
     * </p>
     *
     * @param listRelationshipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListRelationshipsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListRelationships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelationshipsPublisher listRelationshipsPaginator(
            Consumer<ListRelationshipsRequest.Builder> listRelationshipsRequest) {
        return listRelationshipsPaginator(ListRelationshipsRequest.builder().applyMutation(listRelationshipsRequest).build());
    }

    /**
     * <p>
     * Lists tags associated with a specific resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags associated with a specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rejects a pending channel handshake request.
     * </p>
     *
     * @param rejectChannelHandshakeRequest
     * @return A Java Future containing the result of the RejectChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.RejectChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/RejectChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectChannelHandshakeResponse> rejectChannelHandshake(
            RejectChannelHandshakeRequest rejectChannelHandshakeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a pending channel handshake request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectChannelHandshakeRequest.Builder} avoiding the
     * need to create one manually via {@link RejectChannelHandshakeRequest#builder()}
     * </p>
     *
     * @param rejectChannelHandshakeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.RejectChannelHandshakeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RejectChannelHandshake operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.RejectChannelHandshake
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/RejectChannelHandshake"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectChannelHandshakeResponse> rejectChannelHandshake(
            Consumer<RejectChannelHandshakeRequest.Builder> rejectChannelHandshakeRequest) {
        return rejectChannelHandshake(RejectChannelHandshakeRequest.builder().applyMutation(rejectChannelHandshakeRequest)
                .build());
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a program management account.
     * </p>
     *
     * @param updateProgramManagementAccountRequest
     * @return A Java Future containing the result of the UpdateProgramManagementAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.UpdateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProgramManagementAccountResponse> updateProgramManagementAccount(
            UpdateProgramManagementAccountRequest updateProgramManagementAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a program management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProgramManagementAccountRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateProgramManagementAccountRequest#builder()}
     * </p>
     *
     * @param updateProgramManagementAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.UpdateProgramManagementAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateProgramManagementAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.UpdateProgramManagementAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateProgramManagementAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProgramManagementAccountResponse> updateProgramManagementAccount(
            Consumer<UpdateProgramManagementAccountRequest.Builder> updateProgramManagementAccountRequest) {
        return updateProgramManagementAccount(UpdateProgramManagementAccountRequest.builder()
                .applyMutation(updateProgramManagementAccountRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a partner relationship.
     * </p>
     *
     * @param updateRelationshipRequest
     * @return A Java Future containing the result of the UpdateRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.UpdateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRelationshipResponse> updateRelationship(UpdateRelationshipRequest updateRelationshipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a partner relationship.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelationshipRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRelationshipRequest#builder()}
     * </p>
     *
     * @param updateRelationshipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralchannel.model.UpdateRelationshipRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRelationship operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InternalServerException An internal server error occurred while processing the request.</li>
     *         <li>ValidationException The request failed validation due to invalid input parameters.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests being sent in a short period.</li>
     *         <li>AccessDeniedException The request was denied due to insufficient permissions.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PartnerCentralChannelException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample PartnerCentralChannelAsyncClient.UpdateRelationship
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-channel-2024-03-18/UpdateRelationship"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRelationshipResponse> updateRelationship(
            Consumer<UpdateRelationshipRequest.Builder> updateRelationshipRequest) {
        return updateRelationship(UpdateRelationshipRequest.builder().applyMutation(updateRelationshipRequest).build());
    }

    @Override
    default PartnerCentralChannelServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PartnerCentralChannelAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PartnerCentralChannelAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PartnerCentralChannelAsyncClient}.
     */
    static PartnerCentralChannelAsyncClientBuilder builder() {
        return new DefaultPartnerCentralChannelAsyncClientBuilder();
    }
}
