/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.partnercentralchannel.model.PartnerLedSupport;
import software.amazon.awssdk.services.partnercentralchannel.model.ResoldBusiness;
import software.amazon.awssdk.services.partnercentralchannel.model.ResoldEnterprise;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportPlan> {
    private static final SdkField<ResoldBusiness> RESOLD_BUSINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resoldBusiness").getter(SupportPlan.getter(SupportPlan::resoldBusiness)).setter(SupportPlan.setter(Builder::resoldBusiness)).constructor(ResoldBusiness::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resoldBusiness").build()}).build();
    private static final SdkField<ResoldEnterprise> RESOLD_ENTERPRISE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resoldEnterprise").getter(SupportPlan.getter(SupportPlan::resoldEnterprise)).setter(SupportPlan.setter(Builder::resoldEnterprise)).constructor(ResoldEnterprise::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resoldEnterprise").build()}).build();
    private static final SdkField<PartnerLedSupport> PARTNER_LED_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("partnerLedSupport").getter(SupportPlan.getter(SupportPlan::partnerLedSupport)).setter(SupportPlan.setter(Builder::partnerLedSupport)).constructor(PartnerLedSupport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerLedSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLD_BUSINESS_FIELD, RESOLD_ENTERPRISE_FIELD, PARTNER_LED_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupportPlan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ResoldBusiness resoldBusiness;
    private final ResoldEnterprise resoldEnterprise;
    private final PartnerLedSupport partnerLedSupport;
    private final Type type;

    private SupportPlan(BuilderImpl builder) {
        this.resoldBusiness = builder.resoldBusiness;
        this.resoldEnterprise = builder.resoldEnterprise;
        this.partnerLedSupport = builder.partnerLedSupport;
        this.type = builder.type;
    }

    public final ResoldBusiness resoldBusiness() {
        return this.resoldBusiness;
    }

    public final ResoldEnterprise resoldEnterprise() {
        return this.resoldEnterprise;
    }

    public final PartnerLedSupport partnerLedSupport() {
        return this.partnerLedSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resoldBusiness());
        hashCode = 31 * hashCode + Objects.hashCode(this.resoldEnterprise());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerLedSupport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportPlan)) {
            return false;
        }
        SupportPlan other = (SupportPlan)obj;
        return Objects.equals(this.resoldBusiness(), other.resoldBusiness()) && Objects.equals(this.resoldEnterprise(), other.resoldEnterprise()) && Objects.equals(this.partnerLedSupport(), other.partnerLedSupport());
    }

    public final String toString() {
        return ToString.builder((String)"SupportPlan").add("ResoldBusiness", (Object)this.resoldBusiness()).add("ResoldEnterprise", (Object)this.resoldEnterprise()).add("PartnerLedSupport", (Object)this.partnerLedSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resoldBusiness": {
                return Optional.ofNullable(clazz.cast(this.resoldBusiness()));
            }
            case "resoldEnterprise": {
                return Optional.ofNullable(clazz.cast(this.resoldEnterprise()));
            }
            case "partnerLedSupport": {
                return Optional.ofNullable(clazz.cast(this.partnerLedSupport()));
            }
        }
        return Optional.empty();
    }

    public static SupportPlan fromResoldBusiness(ResoldBusiness resoldBusiness) {
        return (SupportPlan)SupportPlan.builder().resoldBusiness(resoldBusiness).build();
    }

    public static SupportPlan fromResoldBusiness(Consumer<ResoldBusiness.Builder> resoldBusiness) {
        ResoldBusiness.Builder builder = ResoldBusiness.builder();
        resoldBusiness.accept(builder);
        return SupportPlan.fromResoldBusiness((ResoldBusiness)builder.build());
    }

    public static SupportPlan fromResoldEnterprise(ResoldEnterprise resoldEnterprise) {
        return (SupportPlan)SupportPlan.builder().resoldEnterprise(resoldEnterprise).build();
    }

    public static SupportPlan fromResoldEnterprise(Consumer<ResoldEnterprise.Builder> resoldEnterprise) {
        ResoldEnterprise.Builder builder = ResoldEnterprise.builder();
        resoldEnterprise.accept(builder);
        return SupportPlan.fromResoldEnterprise((ResoldEnterprise)builder.build());
    }

    public static SupportPlan fromPartnerLedSupport(PartnerLedSupport partnerLedSupport) {
        return (SupportPlan)SupportPlan.builder().partnerLedSupport(partnerLedSupport).build();
    }

    public static SupportPlan fromPartnerLedSupport(Consumer<PartnerLedSupport.Builder> partnerLedSupport) {
        PartnerLedSupport.Builder builder = PartnerLedSupport.builder();
        partnerLedSupport.accept(builder);
        return SupportPlan.fromPartnerLedSupport((PartnerLedSupport)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resoldBusiness", RESOLD_BUSINESS_FIELD);
        map.put("resoldEnterprise", RESOLD_ENTERPRISE_FIELD);
        map.put("partnerLedSupport", PARTNER_LED_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportPlan, T> g) {
        return obj -> g.apply((SupportPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RESOLD_BUSINESS,
        RESOLD_ENTERPRISE,
        PARTNER_LED_SUPPORT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ResoldBusiness resoldBusiness;
        private ResoldEnterprise resoldEnterprise;
        private PartnerLedSupport partnerLedSupport;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SupportPlan model) {
            this.resoldBusiness(model.resoldBusiness);
            this.resoldEnterprise(model.resoldEnterprise);
            this.partnerLedSupport(model.partnerLedSupport);
        }

        public final ResoldBusiness.Builder getResoldBusiness() {
            return this.resoldBusiness != null ? this.resoldBusiness.toBuilder() : null;
        }

        public final void setResoldBusiness(ResoldBusiness.BuilderImpl resoldBusiness) {
            ResoldBusiness oldValue = this.resoldBusiness;
            this.resoldBusiness = resoldBusiness != null ? resoldBusiness.build() : null;
            this.handleUnionValueChange(Type.RESOLD_BUSINESS, oldValue, this.resoldBusiness);
        }

        @Override
        public final Builder resoldBusiness(ResoldBusiness resoldBusiness) {
            ResoldBusiness oldValue = this.resoldBusiness;
            this.resoldBusiness = resoldBusiness;
            this.handleUnionValueChange(Type.RESOLD_BUSINESS, oldValue, this.resoldBusiness);
            return this;
        }

        public final ResoldEnterprise.Builder getResoldEnterprise() {
            return this.resoldEnterprise != null ? this.resoldEnterprise.toBuilder() : null;
        }

        public final void setResoldEnterprise(ResoldEnterprise.BuilderImpl resoldEnterprise) {
            ResoldEnterprise oldValue = this.resoldEnterprise;
            this.resoldEnterprise = resoldEnterprise != null ? resoldEnterprise.build() : null;
            this.handleUnionValueChange(Type.RESOLD_ENTERPRISE, oldValue, this.resoldEnterprise);
        }

        @Override
        public final Builder resoldEnterprise(ResoldEnterprise resoldEnterprise) {
            ResoldEnterprise oldValue = this.resoldEnterprise;
            this.resoldEnterprise = resoldEnterprise;
            this.handleUnionValueChange(Type.RESOLD_ENTERPRISE, oldValue, this.resoldEnterprise);
            return this;
        }

        public final PartnerLedSupport.Builder getPartnerLedSupport() {
            return this.partnerLedSupport != null ? this.partnerLedSupport.toBuilder() : null;
        }

        public final void setPartnerLedSupport(PartnerLedSupport.BuilderImpl partnerLedSupport) {
            PartnerLedSupport oldValue = this.partnerLedSupport;
            this.partnerLedSupport = partnerLedSupport != null ? partnerLedSupport.build() : null;
            this.handleUnionValueChange(Type.PARTNER_LED_SUPPORT, oldValue, this.partnerLedSupport);
        }

        @Override
        public final Builder partnerLedSupport(PartnerLedSupport partnerLedSupport) {
            PartnerLedSupport oldValue = this.partnerLedSupport;
            this.partnerLedSupport = partnerLedSupport;
            this.handleUnionValueChange(Type.PARTNER_LED_SUPPORT, oldValue, this.partnerLedSupport);
            return this;
        }

        public SupportPlan build() {
            return new SupportPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportPlan> {
        public Builder resoldBusiness(ResoldBusiness var1);

        default public Builder resoldBusiness(Consumer<ResoldBusiness.Builder> resoldBusiness) {
            return this.resoldBusiness((ResoldBusiness)((ResoldBusiness.Builder)ResoldBusiness.builder().applyMutation(resoldBusiness)).build());
        }

        public Builder resoldEnterprise(ResoldEnterprise var1);

        default public Builder resoldEnterprise(Consumer<ResoldEnterprise.Builder> resoldEnterprise) {
            return this.resoldEnterprise((ResoldEnterprise)((ResoldEnterprise.Builder)ResoldEnterprise.builder().applyMutation(resoldEnterprise)).build());
        }

        public Builder partnerLedSupport(PartnerLedSupport var1);

        default public Builder partnerLedSupport(Consumer<PartnerLedSupport.Builder> partnerLedSupport) {
            return this.partnerLedSupport((PartnerLedSupport)((PartnerLedSupport.Builder)PartnerLedSupport.builder().applyMutation(partnerLedSupport)).build());
        }
    }
}

