/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralchannel.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Provider {
    DISTRIBUTOR("DISTRIBUTOR"),
    DISTRIBUTION_SELLER("DISTRIBUTION_SELLER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Provider> VALUE_MAP;
    private final String value;

    private Provider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Provider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Provider> knownValues() {
        EnumSet<Provider> knownValues = EnumSet.allOf(Provider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Provider.class, Provider::toString);
    }
}

