/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitAllocationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitIdsCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BenefitAllocationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BenefitAllocationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::id)).setter(BenefitAllocationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::catalog)).setter(BenefitAllocationSummary.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::arn)).setter(BenefitAllocationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::statusAsString)).setter(BenefitAllocationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::statusReason)).setter(BenefitAllocationSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::name)).setter(BenefitAllocationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> BENEFIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitId").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::benefitId)).setter(BenefitAllocationSummary.setter(Builder::benefitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitId").build()}).build();
    private static final SdkField<String> BENEFIT_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitApplicationId").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::benefitApplicationId)).setter(BenefitAllocationSummary.setter(Builder::benefitApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationId").build()}).build();
    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FulfillmentTypes").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::fulfillmentTypesAsStrings)).setter(BenefitAllocationSummary.setter(Builder::fulfillmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::createdAt)).setter(BenefitAllocationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAt").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::expiresAt)).setter(BenefitAllocationSummary.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> APPLICABLE_BENEFIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicableBenefitIds").getter(BenefitAllocationSummary.getter(BenefitAllocationSummary::applicableBenefitIds)).setter(BenefitAllocationSummary.setter(Builder::applicableBenefitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicableBenefitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CATALOG_FIELD, ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, NAME_FIELD, BENEFIT_ID_FIELD, BENEFIT_APPLICATION_ID_FIELD, FULFILLMENT_TYPES_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD, APPLICABLE_BENEFIT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BenefitAllocationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String catalog;
    private final String arn;
    private final String status;
    private final String statusReason;
    private final String name;
    private final String benefitId;
    private final String benefitApplicationId;
    private final List<String> fulfillmentTypes;
    private final Instant createdAt;
    private final Instant expiresAt;
    private final List<String> applicableBenefitIds;

    private BenefitAllocationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.catalog = builder.catalog;
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.name = builder.name;
        this.benefitId = builder.benefitId;
        this.benefitApplicationId = builder.benefitApplicationId;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.applicableBenefitIds = builder.applicableBenefitIds;
    }

    public final String id() {
        return this.id;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String arn() {
        return this.arn;
    }

    public final BenefitAllocationStatus status() {
        return BenefitAllocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String name() {
        return this.name;
    }

    public final String benefitId() {
        return this.benefitId;
    }

    public final String benefitApplicationId() {
        return this.benefitApplicationId;
    }

    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(this.fulfillmentTypes);
    }

    public final boolean hasFulfillmentTypes() {
        return this.fulfillmentTypes != null && !(this.fulfillmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> fulfillmentTypesAsStrings() {
        return this.fulfillmentTypes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final boolean hasApplicableBenefitIds() {
        return this.applicableBenefitIds != null && !(this.applicableBenefitIds instanceof SdkAutoConstructList);
    }

    public final List<String> applicableBenefitIds() {
        return this.applicableBenefitIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicableBenefitIds() ? this.applicableBenefitIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BenefitAllocationSummary)) {
            return false;
        }
        BenefitAllocationSummary other = (BenefitAllocationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.benefitId(), other.benefitId()) && Objects.equals(this.benefitApplicationId(), other.benefitApplicationId()) && this.hasFulfillmentTypes() == other.hasFulfillmentTypes() && Objects.equals(this.fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.expiresAt(), other.expiresAt()) && this.hasApplicableBenefitIds() == other.hasApplicableBenefitIds() && Objects.equals(this.applicableBenefitIds(), other.applicableBenefitIds());
    }

    public final String toString() {
        return ToString.builder((String)"BenefitAllocationSummary").add("Id", (Object)this.id()).add("Catalog", (Object)this.catalog()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Name", (Object)this.name()).add("BenefitId", (Object)this.benefitId()).add("BenefitApplicationId", (Object)this.benefitApplicationId()).add("FulfillmentTypes", this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null).add("CreatedAt", (Object)this.createdAt()).add("ExpiresAt", (Object)this.expiresAt()).add("ApplicableBenefitIds", this.hasApplicableBenefitIds() ? this.applicableBenefitIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BenefitId": {
                return Optional.ofNullable(clazz.cast(this.benefitId()));
            }
            case "BenefitApplicationId": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationId()));
            }
            case "FulfillmentTypes": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypesAsStrings()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "ApplicableBenefitIds": {
                return Optional.ofNullable(clazz.cast(this.applicableBenefitIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("BenefitId", BENEFIT_ID_FIELD);
        map.put("BenefitApplicationId", BENEFIT_APPLICATION_ID_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        map.put("ApplicableBenefitIds", APPLICABLE_BENEFIT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BenefitAllocationSummary, T> g) {
        return obj -> g.apply((BenefitAllocationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String catalog;
        private String arn;
        private String status;
        private String statusReason;
        private String name;
        private String benefitId;
        private String benefitApplicationId;
        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant expiresAt;
        private List<String> applicableBenefitIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BenefitAllocationSummary model) {
            this.id(model.id);
            this.catalog(model.catalog);
            this.arn(model.arn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.name(model.name);
            this.benefitId(model.benefitId);
            this.benefitApplicationId(model.benefitApplicationId);
            this.fulfillmentTypesWithStrings(model.fulfillmentTypes);
            this.createdAt(model.createdAt);
            this.expiresAt(model.expiresAt);
            this.applicableBenefitIds(model.applicableBenefitIds);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBenefitId() {
            return this.benefitId;
        }

        public final void setBenefitId(String benefitId) {
            this.benefitId = benefitId;
        }

        @Override
        public final Builder benefitId(String benefitId) {
            this.benefitId = benefitId;
            return this;
        }

        public final String getBenefitApplicationId() {
            return this.benefitApplicationId;
        }

        public final void setBenefitApplicationId(String benefitApplicationId) {
            this.benefitApplicationId = benefitApplicationId;
        }

        @Override
        public final Builder benefitApplicationId(String benefitApplicationId) {
            this.benefitApplicationId = benefitApplicationId;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (this.fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String ... fulfillmentTypes) {
            this.fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType ... fulfillmentTypes) {
            this.fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final Collection<String> getApplicableBenefitIds() {
            if (this.applicableBenefitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicableBenefitIds;
        }

        public final void setApplicableBenefitIds(Collection<String> applicableBenefitIds) {
            this.applicableBenefitIds = BenefitIdsCopier.copy(applicableBenefitIds);
        }

        @Override
        public final Builder applicableBenefitIds(Collection<String> applicableBenefitIds) {
            this.applicableBenefitIds = BenefitIdsCopier.copy(applicableBenefitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableBenefitIds(String ... applicableBenefitIds) {
            this.applicableBenefitIds(Arrays.asList(applicableBenefitIds));
            return this;
        }

        public BenefitAllocationSummary build() {
            return new BenefitAllocationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BenefitAllocationSummary> {
        public Builder id(String var1);

        public Builder catalog(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(BenefitAllocationStatus var1);

        public Builder statusReason(String var1);

        public Builder name(String var1);

        public Builder benefitId(String var1);

        public Builder benefitApplicationId(String var1);

        public Builder fulfillmentTypesWithStrings(Collection<String> var1);

        public Builder fulfillmentTypesWithStrings(String ... var1);

        public Builder fulfillmentTypes(Collection<FulfillmentType> var1);

        public Builder fulfillmentTypes(FulfillmentType ... var1);

        public Builder createdAt(Instant var1);

        public Builder expiresAt(Instant var1);

        public Builder applicableBenefitIds(Collection<String> var1);

        public Builder applicableBenefitIds(String ... var1);
    }
}

