/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.Amendment;
import software.amazon.awssdk.services.partnercentralbenefits.model.AmendmentListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmendBenefitApplicationRequest
extends PartnerCentralBenefitsRequest
implements ToCopyableBuilder<Builder, AmendBenefitApplicationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(AmendBenefitApplicationRequest.getter(AmendBenefitApplicationRequest::catalog)).setter(AmendBenefitApplicationRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AmendBenefitApplicationRequest.getter(AmendBenefitApplicationRequest::clientToken)).setter(AmendBenefitApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Revision").getter(AmendBenefitApplicationRequest.getter(AmendBenefitApplicationRequest::revision)).setter(AmendBenefitApplicationRequest.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(AmendBenefitApplicationRequest.getter(AmendBenefitApplicationRequest::identifier)).setter(AmendBenefitApplicationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> AMENDMENT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmendmentReason").getter(AmendBenefitApplicationRequest.getter(AmendBenefitApplicationRequest::amendmentReason)).setter(AmendBenefitApplicationRequest.setter(Builder::amendmentReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmendmentReason").build()}).build();
    private static final SdkField<List<Amendment>> AMENDMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Amendments").getter(AmendBenefitApplicationRequest.getter(AmendBenefitApplicationRequest::amendments)).setter(AmendBenefitApplicationRequest.setter(Builder::amendments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amendments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Amendment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CLIENT_TOKEN_FIELD, REVISION_FIELD, IDENTIFIER_FIELD, AMENDMENT_REASON_FIELD, AMENDMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmendBenefitApplicationRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String clientToken;
    private final String revision;
    private final String identifier;
    private final String amendmentReason;
    private final List<Amendment> amendments;

    private AmendBenefitApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.revision = builder.revision;
        this.identifier = builder.identifier;
        this.amendmentReason = builder.amendmentReason;
        this.amendments = builder.amendments;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String revision() {
        return this.revision;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String amendmentReason() {
        return this.amendmentReason;
    }

    public final boolean hasAmendments() {
        return this.amendments != null && !(this.amendments instanceof SdkAutoConstructList);
    }

    public final List<Amendment> amendments() {
        return this.amendments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.amendmentReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmendments() ? this.amendments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmendBenefitApplicationRequest)) {
            return false;
        }
        AmendBenefitApplicationRequest other = (AmendBenefitApplicationRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.amendmentReason(), other.amendmentReason()) && this.hasAmendments() == other.hasAmendments() && Objects.equals(this.amendments(), other.amendments());
    }

    public final String toString() {
        return ToString.builder((String)"AmendBenefitApplicationRequest").add("Catalog", (Object)this.catalog()).add("ClientToken", (Object)this.clientToken()).add("Revision", (Object)this.revision()).add("Identifier", (Object)this.identifier()).add("AmendmentReason", (Object)this.amendmentReason()).add("Amendments", this.hasAmendments() ? this.amendments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "AmendmentReason": {
                return Optional.ofNullable(clazz.cast(this.amendmentReason()));
            }
            case "Amendments": {
                return Optional.ofNullable(clazz.cast(this.amendments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("AmendmentReason", AMENDMENT_REASON_FIELD);
        map.put("Amendments", AMENDMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmendBenefitApplicationRequest, T> g) {
        return obj -> g.apply((AmendBenefitApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String clientToken;
        private String revision;
        private String identifier;
        private String amendmentReason;
        private List<Amendment> amendments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AmendBenefitApplicationRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.clientToken(model.clientToken);
            this.revision(model.revision);
            this.identifier(model.identifier);
            this.amendmentReason(model.amendmentReason);
            this.amendments(model.amendments);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getAmendmentReason() {
            return this.amendmentReason;
        }

        public final void setAmendmentReason(String amendmentReason) {
            this.amendmentReason = amendmentReason;
        }

        @Override
        public final Builder amendmentReason(String amendmentReason) {
            this.amendmentReason = amendmentReason;
            return this;
        }

        public final List<Amendment.Builder> getAmendments() {
            List<Amendment.Builder> result = AmendmentListCopier.copyToBuilder(this.amendments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmendments(Collection<Amendment.BuilderImpl> amendments) {
            this.amendments = AmendmentListCopier.copyFromBuilder(amendments);
        }

        @Override
        public final Builder amendments(Collection<Amendment> amendments) {
            this.amendments = AmendmentListCopier.copy(amendments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amendments(Amendment ... amendments) {
            this.amendments(Arrays.asList(amendments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amendments(Consumer<Amendment.Builder> ... amendments) {
            this.amendments(Stream.of(amendments).map(c -> (Amendment)((Amendment.Builder)Amendment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AmendBenefitApplicationRequest build() {
            return new AmendBenefitApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AmendBenefitApplicationRequest> {
        public Builder catalog(String var1);

        public Builder clientToken(String var1);

        public Builder revision(String var1);

        public Builder identifier(String var1);

        public Builder amendmentReason(String var1);

        public Builder amendments(Collection<Amendment> var1);

        public Builder amendments(Amendment ... var1);

        public Builder amendments(Consumer<Amendment.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

