/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.Contact;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationInputAssociatedResourcesListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationInputFileDetailsListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationInputPartnerContactsListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.CreateBenefitApplicationInputTagsListCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.FileInput;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentType;
import software.amazon.awssdk.services.partnercentralbenefits.model.FulfillmentTypesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsRequest;
import software.amazon.awssdk.services.partnercentralbenefits.model.Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBenefitApplicationRequest
extends PartnerCentralBenefitsRequest
implements ToCopyableBuilder<Builder, CreateBenefitApplicationRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::catalog)).setter(CreateBenefitApplicationRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::clientToken)).setter(CreateBenefitApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::name)).setter(CreateBenefitApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::description)).setter(CreateBenefitApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BENEFIT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BenefitIdentifier").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::benefitIdentifier)).setter(CreateBenefitApplicationRequest.setter(Builder::benefitIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitIdentifier").build()}).build();
    private static final SdkField<List<String>> FULFILLMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FulfillmentTypes").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::fulfillmentTypesAsStrings)).setter(CreateBenefitApplicationRequest.setter(Builder::fulfillmentTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfillmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Document> BENEFIT_APPLICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("BenefitApplicationDetails").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::benefitApplicationDetails)).setter(CreateBenefitApplicationRequest.setter(Builder::benefitApplicationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationDetails").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::tags)).setter(CreateBenefitApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResources").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::associatedResources)).setter(CreateBenefitApplicationRequest.setter(Builder::associatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Contact>> PARTNER_CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartnerContacts").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::partnerContacts)).setter(CreateBenefitApplicationRequest.setter(Builder::partnerContacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerContacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileInput>> FILE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileDetails").getter(CreateBenefitApplicationRequest.getter(CreateBenefitApplicationRequest::fileDetails)).setter(CreateBenefitApplicationRequest.setter(Builder::fileDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, BENEFIT_IDENTIFIER_FIELD, FULFILLMENT_TYPES_FIELD, BENEFIT_APPLICATION_DETAILS_FIELD, TAGS_FIELD, ASSOCIATED_RESOURCES_FIELD, PARTNER_CONTACTS_FIELD, FILE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBenefitApplicationRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final String clientToken;
    private final String name;
    private final String description;
    private final String benefitIdentifier;
    private final List<String> fulfillmentTypes;
    private final Document benefitApplicationDetails;
    private final List<Tag> tags;
    private final List<String> associatedResources;
    private final List<Contact> partnerContacts;
    private final List<FileInput> fileDetails;

    private CreateBenefitApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.benefitIdentifier = builder.benefitIdentifier;
        this.fulfillmentTypes = builder.fulfillmentTypes;
        this.benefitApplicationDetails = builder.benefitApplicationDetails;
        this.tags = builder.tags;
        this.associatedResources = builder.associatedResources;
        this.partnerContacts = builder.partnerContacts;
        this.fileDetails = builder.fileDetails;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String benefitIdentifier() {
        return this.benefitIdentifier;
    }

    public final List<FulfillmentType> fulfillmentTypes() {
        return FulfillmentTypesCopier.copyStringToEnum(this.fulfillmentTypes);
    }

    public final boolean hasFulfillmentTypes() {
        return this.fulfillmentTypes != null && !(this.fulfillmentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> fulfillmentTypesAsStrings() {
        return this.fulfillmentTypes;
    }

    public final Document benefitApplicationDetails() {
        return this.benefitApplicationDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasAssociatedResources() {
        return this.associatedResources != null && !(this.associatedResources instanceof SdkAutoConstructList);
    }

    public final List<String> associatedResources() {
        return this.associatedResources;
    }

    public final boolean hasPartnerContacts() {
        return this.partnerContacts != null && !(this.partnerContacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> partnerContacts() {
        return this.partnerContacts;
    }

    public final boolean hasFileDetails() {
        return this.fileDetails != null && !(this.fileDetails instanceof SdkAutoConstructList);
    }

    public final List<FileInput> fileDetails() {
        return this.fileDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitApplicationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResources() ? this.associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartnerContacts() ? this.partnerContacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileDetails() ? this.fileDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBenefitApplicationRequest)) {
            return false;
        }
        CreateBenefitApplicationRequest other = (CreateBenefitApplicationRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.benefitIdentifier(), other.benefitIdentifier()) && this.hasFulfillmentTypes() == other.hasFulfillmentTypes() && Objects.equals(this.fulfillmentTypesAsStrings(), other.fulfillmentTypesAsStrings()) && Objects.equals(this.benefitApplicationDetails(), other.benefitApplicationDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAssociatedResources() == other.hasAssociatedResources() && Objects.equals(this.associatedResources(), other.associatedResources()) && this.hasPartnerContacts() == other.hasPartnerContacts() && Objects.equals(this.partnerContacts(), other.partnerContacts()) && this.hasFileDetails() == other.hasFileDetails() && Objects.equals(this.fileDetails(), other.fileDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBenefitApplicationRequest").add("Catalog", (Object)this.catalog()).add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("BenefitIdentifier", (Object)this.benefitIdentifier()).add("FulfillmentTypes", this.hasFulfillmentTypes() ? this.fulfillmentTypesAsStrings() : null).add("BenefitApplicationDetails", (Object)this.benefitApplicationDetails()).add("Tags", this.hasTags() ? this.tags() : null).add("AssociatedResources", this.hasAssociatedResources() ? this.associatedResources() : null).add("PartnerContacts", this.hasPartnerContacts() ? this.partnerContacts() : null).add("FileDetails", this.hasFileDetails() ? this.fileDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BenefitIdentifier": {
                return Optional.ofNullable(clazz.cast(this.benefitIdentifier()));
            }
            case "FulfillmentTypes": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentTypesAsStrings()));
            }
            case "BenefitApplicationDetails": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.associatedResources()));
            }
            case "PartnerContacts": {
                return Optional.ofNullable(clazz.cast(this.partnerContacts()));
            }
            case "FileDetails": {
                return Optional.ofNullable(clazz.cast(this.fileDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BenefitIdentifier", BENEFIT_IDENTIFIER_FIELD);
        map.put("FulfillmentTypes", FULFILLMENT_TYPES_FIELD);
        map.put("BenefitApplicationDetails", BENEFIT_APPLICATION_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("PartnerContacts", PARTNER_CONTACTS_FIELD);
        map.put("FileDetails", FILE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBenefitApplicationRequest, T> g) {
        return obj -> g.apply((CreateBenefitApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String clientToken;
        private String name;
        private String description;
        private String benefitIdentifier;
        private List<String> fulfillmentTypes = DefaultSdkAutoConstructList.getInstance();
        private Document benefitApplicationDetails;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();
        private List<Contact> partnerContacts = DefaultSdkAutoConstructList.getInstance();
        private List<FileInput> fileDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBenefitApplicationRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.description(model.description);
            this.benefitIdentifier(model.benefitIdentifier);
            this.fulfillmentTypesWithStrings(model.fulfillmentTypes);
            this.benefitApplicationDetails(model.benefitApplicationDetails);
            this.tags(model.tags);
            this.associatedResources(model.associatedResources);
            this.partnerContacts(model.partnerContacts);
            this.fileDetails(model.fileDetails);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBenefitIdentifier() {
            return this.benefitIdentifier;
        }

        public final void setBenefitIdentifier(String benefitIdentifier) {
            this.benefitIdentifier = benefitIdentifier;
        }

        @Override
        public final Builder benefitIdentifier(String benefitIdentifier) {
            this.benefitIdentifier = benefitIdentifier;
            return this;
        }

        public final Collection<String> getFulfillmentTypes() {
            if (this.fulfillmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fulfillmentTypes;
        }

        public final void setFulfillmentTypes(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
        }

        @Override
        public final Builder fulfillmentTypesWithStrings(Collection<String> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copy(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypesWithStrings(String ... fulfillmentTypes) {
            this.fulfillmentTypesWithStrings(Arrays.asList(fulfillmentTypes));
            return this;
        }

        @Override
        public final Builder fulfillmentTypes(Collection<FulfillmentType> fulfillmentTypes) {
            this.fulfillmentTypes = FulfillmentTypesCopier.copyEnumToString(fulfillmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fulfillmentTypes(FulfillmentType ... fulfillmentTypes) {
            this.fulfillmentTypes(Arrays.asList(fulfillmentTypes));
            return this;
        }

        public final Document getBenefitApplicationDetails() {
            return this.benefitApplicationDetails;
        }

        public final void setBenefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
        }

        @Override
        public final Builder benefitApplicationDetails(Document benefitApplicationDetails) {
            this.benefitApplicationDetails = benefitApplicationDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = CreateBenefitApplicationInputTagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = CreateBenefitApplicationInputTagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = CreateBenefitApplicationInputTagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedResources() {
            if (this.associatedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedResources;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = CreateBenefitApplicationInputAssociatedResourcesListCopier.copy(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = CreateBenefitApplicationInputAssociatedResourcesListCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String ... associatedResources) {
            this.associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final List<Contact.Builder> getPartnerContacts() {
            List<Contact.Builder> result = CreateBenefitApplicationInputPartnerContactsListCopier.copyToBuilder(this.partnerContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerContacts(Collection<Contact.BuilderImpl> partnerContacts) {
            this.partnerContacts = CreateBenefitApplicationInputPartnerContactsListCopier.copyFromBuilder(partnerContacts);
        }

        @Override
        public final Builder partnerContacts(Collection<Contact> partnerContacts) {
            this.partnerContacts = CreateBenefitApplicationInputPartnerContactsListCopier.copy(partnerContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Contact ... partnerContacts) {
            this.partnerContacts(Arrays.asList(partnerContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerContacts(Consumer<Contact.Builder> ... partnerContacts) {
            this.partnerContacts(Stream.of(partnerContacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FileInput.Builder> getFileDetails() {
            List<FileInput.Builder> result = CreateBenefitApplicationInputFileDetailsListCopier.copyToBuilder(this.fileDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileDetails(Collection<FileInput.BuilderImpl> fileDetails) {
            this.fileDetails = CreateBenefitApplicationInputFileDetailsListCopier.copyFromBuilder(fileDetails);
        }

        @Override
        public final Builder fileDetails(Collection<FileInput> fileDetails) {
            this.fileDetails = CreateBenefitApplicationInputFileDetailsListCopier.copy(fileDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(FileInput ... fileDetails) {
            this.fileDetails(Arrays.asList(fileDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileDetails(Consumer<FileInput.Builder> ... fileDetails) {
            this.fileDetails(Stream.of(fileDetails).map(c -> (FileInput)((FileInput.Builder)FileInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBenefitApplicationRequest build() {
            return new CreateBenefitApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBenefitApplicationRequest> {
        public Builder catalog(String var1);

        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder benefitIdentifier(String var1);

        public Builder fulfillmentTypesWithStrings(Collection<String> var1);

        public Builder fulfillmentTypesWithStrings(String ... var1);

        public Builder fulfillmentTypes(Collection<FulfillmentType> var1);

        public Builder fulfillmentTypes(FulfillmentType ... var1);

        public Builder benefitApplicationDetails(Document var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder associatedResources(Collection<String> var1);

        public Builder associatedResources(String ... var1);

        public Builder partnerContacts(Collection<Contact> var1);

        public Builder partnerContacts(Contact ... var1);

        public Builder partnerContacts(Consumer<Contact.Builder> ... var1);

        public Builder fileDetails(Collection<FileInput> var1);

        public Builder fileDetails(FileInput ... var1);

        public Builder fileDetails(Consumer<FileInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

