/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralbenefits.model.FileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileDetail> {
    private static final SdkField<String> FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileURI").getter(FileDetail.getter(FileDetail::fileURI)).setter(FileDetail.setter(Builder::fileURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileURI").build()}).build();
    private static final SdkField<String> BUSINESS_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessUseCase").getter(FileDetail.getter(FileDetail::businessUseCase)).setter(FileDetail.setter(Builder::businessUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessUseCase").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileName").getter(FileDetail.getter(FileDetail::fileName)).setter(FileDetail.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()}).build();
    private static final SdkField<String> FILE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileStatus").getter(FileDetail.getter(FileDetail::fileStatus)).setter(FileDetail.setter(Builder::fileStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatus").build()}).build();
    private static final SdkField<String> FILE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileStatusReason").getter(FileDetail.getter(FileDetail::fileStatusReason)).setter(FileDetail.setter(Builder::fileStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatusReason").build()}).build();
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileType").getter(FileDetail.getter(FileDetail::fileTypeAsString)).setter(FileDetail.setter(Builder::fileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileType").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(FileDetail.getter(FileDetail::createdBy)).setter(FileDetail.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(FileDetail.getter(FileDetail::createdAt)).setter(FileDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_URI_FIELD, BUSINESS_USE_CASE_FIELD, FILE_NAME_FIELD, FILE_STATUS_FIELD, FILE_STATUS_REASON_FIELD, FILE_TYPE_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileURI;
    private final String businessUseCase;
    private final String fileName;
    private final String fileStatus;
    private final String fileStatusReason;
    private final String fileType;
    private final String createdBy;
    private final Instant createdAt;

    private FileDetail(BuilderImpl builder) {
        this.fileURI = builder.fileURI;
        this.businessUseCase = builder.businessUseCase;
        this.fileName = builder.fileName;
        this.fileStatus = builder.fileStatus;
        this.fileStatusReason = builder.fileStatusReason;
        this.fileType = builder.fileType;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
    }

    public final String fileURI() {
        return this.fileURI;
    }

    public final String businessUseCase() {
        return this.businessUseCase;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final String fileStatus() {
        return this.fileStatus;
    }

    public final String fileStatusReason() {
        return this.fileStatusReason;
    }

    public final FileType fileType() {
        return FileType.fromValue(this.fileType);
    }

    public final String fileTypeAsString() {
        return this.fileType;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileDetail)) {
            return false;
        }
        FileDetail other = (FileDetail)obj;
        return Objects.equals(this.fileURI(), other.fileURI()) && Objects.equals(this.businessUseCase(), other.businessUseCase()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.fileStatus(), other.fileStatus()) && Objects.equals(this.fileStatusReason(), other.fileStatusReason()) && Objects.equals(this.fileTypeAsString(), other.fileTypeAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"FileDetail").add("FileURI", (Object)this.fileURI()).add("BusinessUseCase", (Object)this.businessUseCase()).add("FileName", (Object)this.fileName()).add("FileStatus", (Object)this.fileStatus()).add("FileStatusReason", (Object)this.fileStatusReason()).add("FileType", (Object)this.fileTypeAsString()).add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileURI": {
                return Optional.ofNullable(clazz.cast(this.fileURI()));
            }
            case "BusinessUseCase": {
                return Optional.ofNullable(clazz.cast(this.businessUseCase()));
            }
            case "FileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "FileStatus": {
                return Optional.ofNullable(clazz.cast(this.fileStatus()));
            }
            case "FileStatusReason": {
                return Optional.ofNullable(clazz.cast(this.fileStatusReason()));
            }
            case "FileType": {
                return Optional.ofNullable(clazz.cast(this.fileTypeAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileURI", FILE_URI_FIELD);
        map.put("BusinessUseCase", BUSINESS_USE_CASE_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("FileStatus", FILE_STATUS_FIELD);
        map.put("FileStatusReason", FILE_STATUS_REASON_FIELD);
        map.put("FileType", FILE_TYPE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileDetail, T> g) {
        return obj -> g.apply((FileDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileURI;
        private String businessUseCase;
        private String fileName;
        private String fileStatus;
        private String fileStatusReason;
        private String fileType;
        private String createdBy;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FileDetail model) {
            this.fileURI(model.fileURI);
            this.businessUseCase(model.businessUseCase);
            this.fileName(model.fileName);
            this.fileStatus(model.fileStatus);
            this.fileStatusReason(model.fileStatusReason);
            this.fileType(model.fileType);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
        }

        public final String getFileURI() {
            return this.fileURI;
        }

        public final void setFileURI(String fileURI) {
            this.fileURI = fileURI;
        }

        @Override
        public final Builder fileURI(String fileURI) {
            this.fileURI = fileURI;
            return this;
        }

        public final String getBusinessUseCase() {
            return this.businessUseCase;
        }

        public final void setBusinessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
        }

        @Override
        public final Builder businessUseCase(String businessUseCase) {
            this.businessUseCase = businessUseCase;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getFileStatus() {
            return this.fileStatus;
        }

        public final void setFileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public final Builder fileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        public final String getFileStatusReason() {
            return this.fileStatusReason;
        }

        public final void setFileStatusReason(String fileStatusReason) {
            this.fileStatusReason = fileStatusReason;
        }

        @Override
        public final Builder fileStatusReason(String fileStatusReason) {
            this.fileStatusReason = fileStatusReason;
            return this;
        }

        public final String getFileType() {
            return this.fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public FileDetail build() {
            return new FileDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileDetail> {
        public Builder fileURI(String var1);

        public Builder businessUseCase(String var1);

        public Builder fileName(String var1);

        public Builder fileStatus(String var1);

        public Builder fileStatusReason(String var1);

        public Builder fileType(String var1);

        public Builder fileType(FileType var1);

        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);
    }
}

