/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitAllocationStatus;
import software.amazon.awssdk.services.partnercentralbenefits.model.MonetaryValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreditCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreditCode> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreditCode.getter(CreditCode::awsAccountId)).setter(CreditCode.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<MonetaryValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(CreditCode.getter(CreditCode::value)).setter(CreditCode.setter(Builder::value)).constructor(MonetaryValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> AWS_CREDIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsCreditCode").getter(CreditCode.getter(CreditCode::awsCreditCode)).setter(CreditCode.setter(Builder::awsCreditCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsCreditCode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreditCode.getter(CreditCode::statusAsString)).setter(CreditCode.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IssuedAt").getter(CreditCode.getter(CreditCode::issuedAt)).setter(CreditCode.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAt").getter(CreditCode.getter(CreditCode::expiresAt)).setter(CreditCode.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, VALUE_FIELD, AWS_CREDIT_CODE_FIELD, STATUS_FIELD, ISSUED_AT_FIELD, EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreditCode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final MonetaryValue value;
    private final String awsCreditCode;
    private final String status;
    private final Instant issuedAt;
    private final Instant expiresAt;

    private CreditCode(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.value = builder.value;
        this.awsCreditCode = builder.awsCreditCode;
        this.status = builder.status;
        this.issuedAt = builder.issuedAt;
        this.expiresAt = builder.expiresAt;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final MonetaryValue value() {
        return this.value;
    }

    public final String awsCreditCode() {
        return this.awsCreditCode;
    }

    public final BenefitAllocationStatus status() {
        return BenefitAllocationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant issuedAt() {
        return this.issuedAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsCreditCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreditCode)) {
            return false;
        }
        CreditCode other = (CreditCode)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.awsCreditCode(), other.awsCreditCode()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.expiresAt(), other.expiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreditCode").add("AwsAccountId", (Object)this.awsAccountId()).add("Value", (Object)this.value()).add("AwsCreditCode", (Object)this.awsCreditCode()).add("Status", (Object)this.statusAsString()).add("IssuedAt", (Object)this.issuedAt()).add("ExpiresAt", (Object)this.expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "AwsCreditCode": {
                return Optional.ofNullable(clazz.cast(this.awsCreditCode()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "IssuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("AwsCreditCode", AWS_CREDIT_CODE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreditCode, T> g) {
        return obj -> g.apply((CreditCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private MonetaryValue value;
        private String awsCreditCode;
        private String status;
        private Instant issuedAt;
        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreditCode model) {
            this.awsAccountId(model.awsAccountId);
            this.value(model.value);
            this.awsCreditCode(model.awsCreditCode);
            this.status(model.status);
            this.issuedAt(model.issuedAt);
            this.expiresAt(model.expiresAt);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final MonetaryValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(MonetaryValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MonetaryValue value) {
            this.value = value;
            return this;
        }

        public final String getAwsCreditCode() {
            return this.awsCreditCode;
        }

        public final void setAwsCreditCode(String awsCreditCode) {
            this.awsCreditCode = awsCreditCode;
        }

        @Override
        public final Builder awsCreditCode(String awsCreditCode) {
            this.awsCreditCode = awsCreditCode;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BenefitAllocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public CreditCode build() {
            return new CreditCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreditCode> {
        public Builder awsAccountId(String var1);

        public Builder value(MonetaryValue var1);

        default public Builder value(Consumer<MonetaryValue.Builder> value) {
            return this.value((MonetaryValue)((MonetaryValue.Builder)MonetaryValue.builder().applyMutation(value)).build());
        }

        public Builder awsCreditCode(String var1);

        public Builder status(String var1);

        public Builder status(BenefitAllocationStatus var1);

        public Builder issuedAt(Instant var1);

        public Builder expiresAt(Instant var1);
    }
}

