/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralbenefits.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationSummariesCopier;
import software.amazon.awssdk.services.partnercentralbenefits.model.BenefitApplicationSummary;
import software.amazon.awssdk.services.partnercentralbenefits.model.PartnerCentralBenefitsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBenefitApplicationsResponse
extends PartnerCentralBenefitsResponse
implements ToCopyableBuilder<Builder, ListBenefitApplicationsResponse> {
    private static final SdkField<List<BenefitApplicationSummary>> BENEFIT_APPLICATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BenefitApplicationSummaries").getter(ListBenefitApplicationsResponse.getter(ListBenefitApplicationsResponse::benefitApplicationSummaries)).setter(ListBenefitApplicationsResponse.setter(Builder::benefitApplicationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitApplicationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BenefitApplicationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBenefitApplicationsResponse.getter(ListBenefitApplicationsResponse::nextToken)).setter(ListBenefitApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BENEFIT_APPLICATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBenefitApplicationsResponse.memberNameToFieldInitializer();
    private final List<BenefitApplicationSummary> benefitApplicationSummaries;
    private final String nextToken;

    private ListBenefitApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.benefitApplicationSummaries = builder.benefitApplicationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBenefitApplicationSummaries() {
        return this.benefitApplicationSummaries != null && !(this.benefitApplicationSummaries instanceof SdkAutoConstructList);
    }

    public final List<BenefitApplicationSummary> benefitApplicationSummaries() {
        return this.benefitApplicationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBenefitApplicationSummaries() ? this.benefitApplicationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBenefitApplicationsResponse)) {
            return false;
        }
        ListBenefitApplicationsResponse other = (ListBenefitApplicationsResponse)((Object)obj);
        return this.hasBenefitApplicationSummaries() == other.hasBenefitApplicationSummaries() && Objects.equals(this.benefitApplicationSummaries(), other.benefitApplicationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBenefitApplicationsResponse").add("BenefitApplicationSummaries", this.hasBenefitApplicationSummaries() ? this.benefitApplicationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BenefitApplicationSummaries": {
                return Optional.ofNullable(clazz.cast(this.benefitApplicationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BenefitApplicationSummaries", BENEFIT_APPLICATION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBenefitApplicationsResponse, T> g) {
        return obj -> g.apply((ListBenefitApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralBenefitsResponse.BuilderImpl
    implements Builder {
        private List<BenefitApplicationSummary> benefitApplicationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBenefitApplicationsResponse model) {
            super(model);
            this.benefitApplicationSummaries(model.benefitApplicationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<BenefitApplicationSummary.Builder> getBenefitApplicationSummaries() {
            List<BenefitApplicationSummary.Builder> result = BenefitApplicationSummariesCopier.copyToBuilder(this.benefitApplicationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBenefitApplicationSummaries(Collection<BenefitApplicationSummary.BuilderImpl> benefitApplicationSummaries) {
            this.benefitApplicationSummaries = BenefitApplicationSummariesCopier.copyFromBuilder(benefitApplicationSummaries);
        }

        @Override
        public final Builder benefitApplicationSummaries(Collection<BenefitApplicationSummary> benefitApplicationSummaries) {
            this.benefitApplicationSummaries = BenefitApplicationSummariesCopier.copy(benefitApplicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitApplicationSummaries(BenefitApplicationSummary ... benefitApplicationSummaries) {
            this.benefitApplicationSummaries(Arrays.asList(benefitApplicationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder benefitApplicationSummaries(Consumer<BenefitApplicationSummary.Builder> ... benefitApplicationSummaries) {
            this.benefitApplicationSummaries(Stream.of(benefitApplicationSummaries).map(c -> (BenefitApplicationSummary)((BenefitApplicationSummary.Builder)BenefitApplicationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBenefitApplicationsResponse build() {
            return new ListBenefitApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralBenefitsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBenefitApplicationsResponse> {
        public Builder benefitApplicationSummaries(Collection<BenefitApplicationSummary> var1);

        public Builder benefitApplicationSummaries(BenefitApplicationSummary ... var1);

        public Builder benefitApplicationSummaries(Consumer<BenefitApplicationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

