/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.VerificationResponseDetails;
import software.amazon.awssdk.services.partnercentralaccount.model.VerificationStatus;
import software.amazon.awssdk.services.partnercentralaccount.model.VerificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVerificationResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, GetVerificationResponse> {
    private static final SdkField<String> VERIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationType").getter(GetVerificationResponse.getter(GetVerificationResponse::verificationTypeAsString)).setter(GetVerificationResponse.setter(Builder::verificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationType").build()}).build();
    private static final SdkField<String> VERIFICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationStatus").getter(GetVerificationResponse.getter(GetVerificationResponse::verificationStatusAsString)).setter(GetVerificationResponse.setter(Builder::verificationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationStatus").build()}).build();
    private static final SdkField<String> VERIFICATION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationStatusReason").getter(GetVerificationResponse.getter(GetVerificationResponse::verificationStatusReason)).setter(GetVerificationResponse.setter(Builder::verificationStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationStatusReason").build()}).build();
    private static final SdkField<VerificationResponseDetails> VERIFICATION_RESPONSE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationResponseDetails").getter(GetVerificationResponse.getter(GetVerificationResponse::verificationResponseDetails)).setter(GetVerificationResponse.setter(Builder::verificationResponseDetails)).constructor(VerificationResponseDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationResponseDetails").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(GetVerificationResponse.getter(GetVerificationResponse::startedAt)).setter(GetVerificationResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedAt").getter(GetVerificationResponse.getter(GetVerificationResponse::completedAt)).setter(GetVerificationResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFICATION_TYPE_FIELD, VERIFICATION_STATUS_FIELD, VERIFICATION_STATUS_REASON_FIELD, VERIFICATION_RESPONSE_DETAILS_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetVerificationResponse.memberNameToFieldInitializer();
    private final String verificationType;
    private final String verificationStatus;
    private final String verificationStatusReason;
    private final VerificationResponseDetails verificationResponseDetails;
    private final Instant startedAt;
    private final Instant completedAt;

    private GetVerificationResponse(BuilderImpl builder) {
        super(builder);
        this.verificationType = builder.verificationType;
        this.verificationStatus = builder.verificationStatus;
        this.verificationStatusReason = builder.verificationStatusReason;
        this.verificationResponseDetails = builder.verificationResponseDetails;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
    }

    public final VerificationType verificationType() {
        return VerificationType.fromValue(this.verificationType);
    }

    public final String verificationTypeAsString() {
        return this.verificationType;
    }

    public final VerificationStatus verificationStatus() {
        return VerificationStatus.fromValue(this.verificationStatus);
    }

    public final String verificationStatusAsString() {
        return this.verificationStatus;
    }

    public final String verificationStatusReason() {
        return this.verificationStatusReason;
    }

    public final VerificationResponseDetails verificationResponseDetails() {
        return this.verificationResponseDetails;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationResponseDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVerificationResponse)) {
            return false;
        }
        GetVerificationResponse other = (GetVerificationResponse)((Object)obj);
        return Objects.equals(this.verificationTypeAsString(), other.verificationTypeAsString()) && Objects.equals(this.verificationStatusAsString(), other.verificationStatusAsString()) && Objects.equals(this.verificationStatusReason(), other.verificationStatusReason()) && Objects.equals(this.verificationResponseDetails(), other.verificationResponseDetails()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetVerificationResponse").add("VerificationType", (Object)this.verificationTypeAsString()).add("VerificationStatus", (Object)this.verificationStatusAsString()).add("VerificationStatusReason", (Object)this.verificationStatusReason()).add("VerificationResponseDetails", (Object)this.verificationResponseDetails()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerificationType": {
                return Optional.ofNullable(clazz.cast(this.verificationTypeAsString()));
            }
            case "VerificationStatus": {
                return Optional.ofNullable(clazz.cast(this.verificationStatusAsString()));
            }
            case "VerificationStatusReason": {
                return Optional.ofNullable(clazz.cast(this.verificationStatusReason()));
            }
            case "VerificationResponseDetails": {
                return Optional.ofNullable(clazz.cast(this.verificationResponseDetails()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VerificationType", VERIFICATION_TYPE_FIELD);
        map.put("VerificationStatus", VERIFICATION_STATUS_FIELD);
        map.put("VerificationStatusReason", VERIFICATION_STATUS_REASON_FIELD);
        map.put("VerificationResponseDetails", VERIFICATION_RESPONSE_DETAILS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("CompletedAt", COMPLETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVerificationResponse, T> g) {
        return obj -> g.apply((GetVerificationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private String verificationType;
        private String verificationStatus;
        private String verificationStatusReason;
        private VerificationResponseDetails verificationResponseDetails;
        private Instant startedAt;
        private Instant completedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVerificationResponse model) {
            super(model);
            this.verificationType(model.verificationType);
            this.verificationStatus(model.verificationStatus);
            this.verificationStatusReason(model.verificationStatusReason);
            this.verificationResponseDetails(model.verificationResponseDetails);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
        }

        public final String getVerificationType() {
            return this.verificationType;
        }

        public final void setVerificationType(String verificationType) {
            this.verificationType = verificationType;
        }

        @Override
        public final Builder verificationType(String verificationType) {
            this.verificationType = verificationType;
            return this;
        }

        @Override
        public final Builder verificationType(VerificationType verificationType) {
            this.verificationType(verificationType == null ? null : verificationType.toString());
            return this;
        }

        public final String getVerificationStatus() {
            return this.verificationStatus;
        }

        public final void setVerificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
        }

        @Override
        public final Builder verificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        @Override
        public final Builder verificationStatus(VerificationStatus verificationStatus) {
            this.verificationStatus(verificationStatus == null ? null : verificationStatus.toString());
            return this;
        }

        public final String getVerificationStatusReason() {
            return this.verificationStatusReason;
        }

        public final void setVerificationStatusReason(String verificationStatusReason) {
            this.verificationStatusReason = verificationStatusReason;
        }

        @Override
        public final Builder verificationStatusReason(String verificationStatusReason) {
            this.verificationStatusReason = verificationStatusReason;
            return this;
        }

        public final VerificationResponseDetails.Builder getVerificationResponseDetails() {
            return this.verificationResponseDetails != null ? this.verificationResponseDetails.toBuilder() : null;
        }

        public final void setVerificationResponseDetails(VerificationResponseDetails.BuilderImpl verificationResponseDetails) {
            this.verificationResponseDetails = verificationResponseDetails != null ? verificationResponseDetails.build() : null;
        }

        @Override
        public final Builder verificationResponseDetails(VerificationResponseDetails verificationResponseDetails) {
            this.verificationResponseDetails = verificationResponseDetails;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public GetVerificationResponse build() {
            return new GetVerificationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVerificationResponse> {
        public Builder verificationType(String var1);

        public Builder verificationType(VerificationType var1);

        public Builder verificationStatus(String var1);

        public Builder verificationStatus(VerificationStatus var1);

        public Builder verificationStatusReason(String var1);

        public Builder verificationResponseDetails(VerificationResponseDetails var1);

        default public Builder verificationResponseDetails(Consumer<VerificationResponseDetails.Builder> verificationResponseDetails) {
            return this.verificationResponseDetails((VerificationResponseDetails)((VerificationResponseDetails.Builder)VerificationResponseDetails.builder().applyMutation(verificationResponseDetails)).build());
        }

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);
    }
}

