/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionTypeStatus {
    ACTIVE("ACTIVE"),
    CANCELED("CANCELED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionTypeStatus> VALUE_MAP;
    private final String value;

    private ConnectionTypeStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionTypeStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionTypeStatus> knownValues() {
        EnumSet<ConnectionTypeStatus> knownValues = EnumSet.allOf(ConnectionTypeStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionTypeStatus.class, ConnectionTypeStatus::toString);
    }
}

