/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IndustrySegment {
    AGRICULTURE_MINING("AGRICULTURE_MINING"),
    BIOTECHNOLOGY("BIOTECHNOLOGY"),
    BUSINESS_CONSUMER_SERVICES("BUSINESS_CONSUMER_SERVICES"),
    BUSINESS_SERV("BUSINESS_SERV"),
    COMMUNICATIONS("COMMUNICATIONS"),
    COMPUTER_HARDWARE("COMPUTER_HARDWARE"),
    COMPUTERS_ELECTRONICS("COMPUTERS_ELECTRONICS"),
    COMPUTER_SOFTWARE("COMPUTER_SOFTWARE"),
    CONSUMER_GOODS("CONSUMER_GOODS"),
    CONSUMER_RELATED("CONSUMER_RELATED"),
    EDUCATION("EDUCATION"),
    ENERGY_UTILITIES("ENERGY_UTILITIES"),
    FINANCIAL_SERVICES("FINANCIAL_SERVICES"),
    GAMING("GAMING"),
    GOVERNMENT("GOVERNMENT"),
    GOVERNMENT_EDUCATION_PUBLIC_SERVICES("GOVERNMENT_EDUCATION_PUBLIC_SERVICES"),
    HEALTHCARE("HEALTHCARE"),
    HEALTHCARE_PHARMACEUTICALS_BIOTECH("HEALTHCARE_PHARMACEUTICALS_BIOTECH"),
    INDUSTRIAL_ENERGY("INDUSTRIAL_ENERGY"),
    INTERNET_SPECIFIC("INTERNET_SPECIFIC"),
    LIFE_SCIENCES("LIFE_SCIENCES"),
    MANUFACTURING("MANUFACTURING"),
    MEDIA_ENTERTAINMENT_LEISURE("MEDIA_ENTERTAINMENT_LEISURE"),
    MEDIA_ENTERTAINMENT("MEDIA_ENTERTAINMENT"),
    MEDICAL_HEALTH("MEDICAL_HEALTH"),
    NON_PROFIT_ORGANIZATION("NON_PROFIT_ORGANIZATION"),
    OTHER("OTHER"),
    PROFESSIONAL_SERVICES("PROFESSIONAL_SERVICES"),
    REAL_ESTATE_CONSTRUCTION("REAL_ESTATE_CONSTRUCTION"),
    RETAIL("RETAIL"),
    RETAIL_WHOLESALE_DISTRIBUTION("RETAIL_WHOLESALE_DISTRIBUTION"),
    SEMICONDUCTOR_ELECTR("SEMICONDUCTOR_ELECTR"),
    SOFTWARE_INTERNET("SOFTWARE_INTERNET"),
    TELECOMMUNICATIONS("TELECOMMUNICATIONS"),
    TRANSPORTATION_LOGISTICS("TRANSPORTATION_LOGISTICS"),
    TRAVEL_HOSPITALITY("TRAVEL_HOSPITALITY"),
    WHOLESALE_DISTRIBUTION("WHOLESALE_DISTRIBUTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndustrySegment> VALUE_MAP;
    private final String value;

    private IndustrySegment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndustrySegment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndustrySegment> knownValues() {
        EnumSet<IndustrySegment> knownValues = EnumSet.allOf(IndustrySegment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IndustrySegment.class, IndustrySegment::toString);
    }
}

