/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.VerificationDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartVerificationRequest
extends PartnerCentralAccountRequest
implements ToCopyableBuilder<Builder, StartVerificationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartVerificationRequest.getter(StartVerificationRequest::clientToken)).setter(StartVerificationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<VerificationDetails> VERIFICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationDetails").getter(StartVerificationRequest.getter(StartVerificationRequest::verificationDetails)).setter(StartVerificationRequest.setter(Builder::verificationDetails)).constructor(VerificationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, VERIFICATION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartVerificationRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final VerificationDetails verificationDetails;

    private StartVerificationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.verificationDetails = builder.verificationDetails;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final VerificationDetails verificationDetails() {
        return this.verificationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVerificationRequest)) {
            return false;
        }
        StartVerificationRequest other = (StartVerificationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.verificationDetails(), other.verificationDetails());
    }

    public final String toString() {
        return ToString.builder((String)"StartVerificationRequest").add("ClientToken", (Object)this.clientToken()).add("VerificationDetails", (Object)this.verificationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "VerificationDetails": {
                return Optional.ofNullable(clazz.cast(this.verificationDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("VerificationDetails", VERIFICATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartVerificationRequest, T> g) {
        return obj -> g.apply((StartVerificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private VerificationDetails verificationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVerificationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.verificationDetails(model.verificationDetails);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final VerificationDetails.Builder getVerificationDetails() {
            return this.verificationDetails != null ? this.verificationDetails.toBuilder() : null;
        }

        public final void setVerificationDetails(VerificationDetails.BuilderImpl verificationDetails) {
            this.verificationDetails = verificationDetails != null ? verificationDetails.build() : null;
        }

        @Override
        public final Builder verificationDetails(VerificationDetails verificationDetails) {
            this.verificationDetails = verificationDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVerificationRequest build() {
            return new StartVerificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartVerificationRequest> {
        public Builder clientToken(String var1);

        public Builder verificationDetails(VerificationDetails var1);

        default public Builder verificationDetails(Consumer<VerificationDetails.Builder> verificationDetails) {
            return this.verificationDetails((VerificationDetails)((VerificationDetails.Builder)VerificationDetails.builder().applyMutation(verificationDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

