/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralaccount.PartnerCentralAccountAsyncClient;
import software.amazon.awssdk.services.partnercentralaccount.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.ListConnectionsRequest;
import software.amazon.awssdk.services.partnercentralaccount.model.ListConnectionsResponse;

public class ListConnectionsPublisher
implements SdkPublisher<ListConnectionsResponse> {
    private final PartnerCentralAccountAsyncClient client;
    private final ListConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectionsPublisher(PartnerCentralAccountAsyncClient client, ListConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectionsPublisher(PartnerCentralAccountAsyncClient client, ListConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectionSummary> connectionSummaries() {
        Function<ListConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionSummaries() != null) {
                return response.connectionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectionsResponseFetcher
    implements AsyncPageFetcher<ListConnectionsResponse> {
        private ListConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectionsResponse> nextPage(ListConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionsPublisher.this.client.listConnections(ListConnectionsPublisher.this.firstRequest);
            }
            return ListConnectionsPublisher.this.client.listConnections((ListConnectionsRequest)((Object)ListConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

