/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerCentralAccountResponse;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerSummary;
import software.amazon.awssdk.services.partnercentralaccount.model.PartnerSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartnersResponse
extends PartnerCentralAccountResponse
implements ToCopyableBuilder<Builder, ListPartnersResponse> {
    private static final SdkField<List<PartnerSummary>> PARTNER_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartnerSummaryList").getter(ListPartnersResponse.getter(ListPartnersResponse::partnerSummaryList)).setter(ListPartnersResponse.setter(Builder::partnerSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartnerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPartnersResponse.getter(ListPartnersResponse::nextToken)).setter(ListPartnersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPartnersResponse.memberNameToFieldInitializer();
    private final List<PartnerSummary> partnerSummaryList;
    private final String nextToken;

    private ListPartnersResponse(BuilderImpl builder) {
        super(builder);
        this.partnerSummaryList = builder.partnerSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPartnerSummaryList() {
        return this.partnerSummaryList != null && !(this.partnerSummaryList instanceof SdkAutoConstructList);
    }

    public final List<PartnerSummary> partnerSummaryList() {
        return this.partnerSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartnerSummaryList() ? this.partnerSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnersResponse)) {
            return false;
        }
        ListPartnersResponse other = (ListPartnersResponse)((Object)obj);
        return this.hasPartnerSummaryList() == other.hasPartnerSummaryList() && Objects.equals(this.partnerSummaryList(), other.partnerSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPartnersResponse").add("PartnerSummaryList", this.hasPartnerSummaryList() ? this.partnerSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartnerSummaryList": {
                return Optional.ofNullable(clazz.cast(this.partnerSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PartnerSummaryList", PARTNER_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPartnersResponse, T> g) {
        return obj -> g.apply((ListPartnersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralAccountResponse.BuilderImpl
    implements Builder {
        private List<PartnerSummary> partnerSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnersResponse model) {
            super(model);
            this.partnerSummaryList(model.partnerSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<PartnerSummary.Builder> getPartnerSummaryList() {
            List<PartnerSummary.Builder> result = PartnerSummaryListCopier.copyToBuilder(this.partnerSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerSummaryList(Collection<PartnerSummary.BuilderImpl> partnerSummaryList) {
            this.partnerSummaryList = PartnerSummaryListCopier.copyFromBuilder(partnerSummaryList);
        }

        @Override
        public final Builder partnerSummaryList(Collection<PartnerSummary> partnerSummaryList) {
            this.partnerSummaryList = PartnerSummaryListCopier.copy(partnerSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerSummaryList(PartnerSummary ... partnerSummaryList) {
            this.partnerSummaryList(Arrays.asList(partnerSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerSummaryList(Consumer<PartnerSummary.Builder> ... partnerSummaryList) {
            this.partnerSummaryList(Stream.of(partnerSummaryList).map(c -> (PartnerSummary)((PartnerSummary.Builder)PartnerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPartnersResponse build() {
            return new ListPartnersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralAccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartnersResponse> {
        public Builder partnerSummaryList(Collection<PartnerSummary> var1);

        public Builder partnerSummaryList(PartnerSummary ... var1);

        public Builder partnerSummaryList(Consumer<PartnerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

