/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralaccount.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.partnercentralaccount.model.ConnectionType;
import software.amazon.awssdk.services.partnercentralaccount.model.InvitationStatus;
import software.amazon.awssdk.services.partnercentralaccount.model.ParticipantType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionInvitationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionInvitationSummary> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::catalog)).setter(ConnectionInvitationSummary.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::id)).setter(ConnectionInvitationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::arn)).setter(ConnectionInvitationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::connectionId)).setter(ConnectionInvitationSummary.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::connectionTypeAsString)).setter(ConnectionInvitationSummary.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::createdAt)).setter(ConnectionInvitationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::updatedAt)).setter(ConnectionInvitationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAt").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::expiresAt)).setter(ConnectionInvitationSummary.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OTHER_PARTICIPANT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherParticipantIdentifier").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::otherParticipantIdentifier)).setter(ConnectionInvitationSummary.setter(Builder::otherParticipantIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherParticipantIdentifier").build()}).build();
    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantType").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::participantTypeAsString)).setter(ConnectionInvitationSummary.setter(Builder::participantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ConnectionInvitationSummary.getter(ConnectionInvitationSummary::statusAsString)).setter(ConnectionInvitationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, ID_FIELD, ARN_FIELD, CONNECTION_ID_FIELD, CONNECTION_TYPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, EXPIRES_AT_FIELD, OTHER_PARTICIPANT_IDENTIFIER_FIELD, PARTICIPANT_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionInvitationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalog;
    private final String id;
    private final String arn;
    private final String connectionId;
    private final String connectionType;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant expiresAt;
    private final String otherParticipantIdentifier;
    private final String participantType;
    private final String status;

    private ConnectionInvitationSummary(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.id = builder.id;
        this.arn = builder.arn;
        this.connectionId = builder.connectionId;
        this.connectionType = builder.connectionType;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.expiresAt = builder.expiresAt;
        this.otherParticipantIdentifier = builder.otherParticipantIdentifier;
        this.participantType = builder.participantType;
        this.status = builder.status;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final String otherParticipantIdentifier() {
        return this.otherParticipantIdentifier;
    }

    public final ParticipantType participantType() {
        return ParticipantType.fromValue(this.participantType);
    }

    public final String participantTypeAsString() {
        return this.participantType;
    }

    public final InvitationStatus status() {
        return InvitationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherParticipantIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInvitationSummary)) {
            return false;
        }
        ConnectionInvitationSummary other = (ConnectionInvitationSummary)obj;
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.otherParticipantIdentifier(), other.otherParticipantIdentifier()) && Objects.equals(this.participantTypeAsString(), other.participantTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionInvitationSummary").add("Catalog", (Object)this.catalog()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ConnectionId", (Object)this.connectionId()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ExpiresAt", (Object)this.expiresAt()).add("OtherParticipantIdentifier", (Object)this.otherParticipantIdentifier()).add("ParticipantType", (Object)this.participantTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "OtherParticipantIdentifier": {
                return Optional.ofNullable(clazz.cast(this.otherParticipantIdentifier()));
            }
            case "ParticipantType": {
                return Optional.ofNullable(clazz.cast(this.participantTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ConnectionId", CONNECTION_ID_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        map.put("OtherParticipantIdentifier", OTHER_PARTICIPANT_IDENTIFIER_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionInvitationSummary, T> g) {
        return obj -> g.apply((ConnectionInvitationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalog;
        private String id;
        private String arn;
        private String connectionId;
        private String connectionType;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant expiresAt;
        private String otherParticipantIdentifier;
        private String participantType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionInvitationSummary model) {
            this.catalog(model.catalog);
            this.id(model.id);
            this.arn(model.arn);
            this.connectionId(model.connectionId);
            this.connectionType(model.connectionType);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.expiresAt(model.expiresAt);
            this.otherParticipantIdentifier(model.otherParticipantIdentifier);
            this.participantType(model.participantType);
            this.status(model.status);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getOtherParticipantIdentifier() {
            return this.otherParticipantIdentifier;
        }

        public final void setOtherParticipantIdentifier(String otherParticipantIdentifier) {
            this.otherParticipantIdentifier = otherParticipantIdentifier;
        }

        @Override
        public final Builder otherParticipantIdentifier(String otherParticipantIdentifier) {
            this.otherParticipantIdentifier = otherParticipantIdentifier;
            return this;
        }

        public final String getParticipantType() {
            return this.participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ConnectionInvitationSummary build() {
            return new ConnectionInvitationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionInvitationSummary> {
        public Builder catalog(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder connectionId(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder expiresAt(Instant var1);

        public Builder otherParticipantIdentifier(String var1);

        public Builder participantType(String var1);

        public Builder participantType(ParticipantType var1);

        public Builder status(String var1);

        public Builder status(InvitationStatus var1);
    }
}

